package cn.easyutil.easyapi.filter;

import cn.easyutil.easyapi.entity.common.BodyType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import org.springframework.web.bind.annotation.*;

import java.lang.reflect.Method;
import java.util.List;

/**
 * 读取接口方法相关的api
 */
public abstract class ReadInterfaceApiFilter{

    public abstract List<Method> readAllInterfaces(Class controller, ApiExtra extra);

    /**
     * 读取接口是否忽略
     * @param method
     * @return  true：忽略  false：非忽略
     */
    public abstract boolean ignore(Method method, ApiExtra extra);

    /**
     * 是否展示接口
     * @param method
     * @param extra
     * @return
     */
    public abstract boolean show(Method method, ApiExtra extra);

    /**
     * 更新策略
     */
    public abstract  RenewType renewType(Method method, ApiExtra extra);


    /**
     * 读取接口请求体类型
     * @param method
     * @return
     */
    public abstract BodyType bodyType(Method method, ApiExtra extra);

    /**
     * 读取接口请求路径
     * @param method    接口方法
     * @return  请求路径
     */
    public abstract String requestUrl(Method method, ApiExtra extra);

    /**
     * 自定义搜索标签
     * @param method    接口方法
     * @param extra 扩展信息
     */
    public abstract List<String> customSearch(Method method, ApiExtra extra);

    /**
     * 读取接口请求方式
     * @param method    接口方法
     * @return  请求路径
     */
    public abstract RequestMethod requestMethod(Method method, ApiExtra extra);

    /**
     * 读取接口名称
     * @param method    接口方法
     * @return  接口名称
     */
    public abstract String showName(Method method, ApiExtra extra);

    /**
     * 读取接口说明
     * @param method    接口方法
     * @return  接口说明
     */
    public abstract String description(Method method, ApiExtra extra);

    /**
     * 接口唯一标识
     * @param method
     * @return
     */
    public abstract String unique(Method method, ApiExtra extra);

    /**
     * 根据tag确定要mock的接口是哪一个
     * @param tag   请求时传进来的tag标识
     * @param entity    接口实例
     * @return  确定是否请求了当前接口
     */
    public abstract boolean verifyMockTag(String tag, DBModuleInterfaceEntity entity);

    /**
     * 是否开启请求参数外包装(如果存在包装的话)
     * @param method    接口方法
     * @param extra  参考数据
     */
    public abstract boolean enableReqPackage(Method method, ApiExtra extra);

    /**
     * 是否开启响应参数外包装(如果存在包装的话)
     * @param method    接口方法
     * @param extra  参考数据
     */
    public abstract boolean enableResPackage(Method method, ApiExtra extra);

}
