package cn.easyutil.easyapi.entity.db.unit;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.logic.unit.OperEnum;

import java.sql.Blob;

/**
 * 测试详细数据
 */
@Tne("EASYAPI_COMPLEX_TEST_INFO")
public class DBComplexTestInfoEntity extends BaseDbEntity {

    @Tfd(value = "TEST_ID",ddl = "`TEST_ID` bigint(20) DEFAULT NULL COMMENT '单元测试id'")
    @ApidocComment("单元测试id")
    private Long testId;

    @Tfd(value = "INTERFACE_ID",ddl = "`INTERFACE_ID` bigint(20) DEFAULT NULL COMMENT '接口id'")
    @ApidocComment("接口id")
    private Long interfaceId;

    @Tfd(value = "HTTP_STATUS",ddl = "`HTTP_STATUS` int(5) DEFAULT NULL COMMENT 'http状态码'")
    @ApidocComment("http状态码")
    private Integer httpStatus;

    @Tfd(value = "SUCCESS_KEY",ddl = "`SUCCESS_KEY` varchar(255) DEFAULT NULL COMMENT '接口成功标志的key(取结果集字段,嵌套使用.获取属性)'")
    @ApidocComment("接口成功标志的key(取结果集字段,嵌套使用.获取属性)")
    private String successKey;

    /**
     * @see OperEnum
     */
    @Tfd(value = "SUCCESS_OPER",ddl = "`SUCCESS_OPER` varchar(20) DEFAULT NULL COMMENT '接口成功标志的key对应的运算符'")
    @ApidocComment("接口成功标志的key对应的运算符")
    private String successOper;

    @Tfd(value = "SUCCESS_VAL",ddl = "`SUCCESS_VAL` varchar(255) DEFAULT NULL COMMENT '接口成功标志的key对应的运算符计算后的结果'")
    @ApidocComment("接口成功标志的key对应的运算符计算后的结果")
    private String successVal;

    @Tfd(value = "REAL_VAL",ddl = "`REAL_VAL` varchar(255) DEFAULT NULL COMMENT '真实返回的值'")
    @ApidocComment("真实返回的值")
    private String realVal;

    @Tfd(value = "REQUEST_HEADERS",ddl = "`REQUEST_HEADERS` varchar(255) DEFAULT NULL COMMENT '请求头'")
    @ApidocComment("请求头")
    private String requestHeaders;

    @Tfd(value = "REQUEST_PARAM",ddl = "`REQUEST_PARAM` varchar(255) DEFAULT NULL COMMENT '请求参数'")
    @ApidocComment("请求参数")
    private String requestParam;

    @Tfd(value = "RESPONSE_HEADERS",ddl = "`RESPONSE_HEADERS` varchar(255) DEFAULT NULL COMMENT '响应头'")
    @ApidocComment("响应头")
    private String responseHeaders;

    @Tfd(value = "RESPONSE_PARAM",type = Blob.class,ddl = "`RESPONSE_PARAM` BLOB DEFAULT NULL COMMENT '响应结果'")
    @ApidocComment("响应结果")
    private String responseResult;

    @Tfd(value = "SUCCESS_STATUS",ddl = "`SUCCESS_STATUS` int(1) DEFAULT 0 COMMENT '0-失败 1-成功'")
    @ApidocComment("0-失败 1-成功")
    private Integer successStatus;

    public Long getTestId() {
        return testId;
    }

    public void setTestId(Long testId) {
        this.testId = testId;
    }

    public Integer getHttpStatus() {
        return httpStatus;
    }

    public void setHttpStatus(Integer httpStatus) {
        this.httpStatus = httpStatus;
    }

    public String getRequestHeaders() {
        return requestHeaders;
    }

    public void setRequestHeaders(String requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public String getRequestParam() {
        return requestParam;
    }

    public void setRequestParam(String requestParam) {
        this.requestParam = requestParam;
    }

    public String getResponseHeaders() {
        return responseHeaders;
    }

    public void setResponseHeaders(String responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public String getResponseResult() {
        return responseResult;
    }

    public void setResponseResult(String responseResult) {
        this.responseResult = responseResult;
    }

    public Integer getSuccessStatus() {
        return successStatus;
    }

    public void setSuccessStatus(Integer successStatus) {
        this.successStatus = successStatus;
    }

    public String getSuccessKey() {
        return successKey;
    }

    public void setSuccessKey(String successKey) {
        this.successKey = successKey;
    }

    public String getSuccessOper() {
        return successOper;
    }

    public void setSuccessOper(String successOper) {
        this.successOper = successOper;
    }

    public String getSuccessVal() {
        return successVal;
    }

    public void setSuccessVal(String successVal) {
        this.successVal = successVal;
    }

    public String getRealVal() {
        return realVal;
    }

    public void setRealVal(String realVal) {
        this.realVal = realVal;
    }

    public Long getInterfaceId() {
        return interfaceId;
    }

    public void setInterfaceId(Long interfaceId) {
        this.interfaceId = interfaceId;
    }
}
