package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.common.EasyapiOrigin;
import cn.easyutil.easyapi.util.EasyapiOriginUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.RequestMethod;

import java.sql.Blob;

/**
 * 接口
 */
@Tne("EASYAPI_MODULE_INTERFACE")
public class DBModuleInterfaceEntity extends BaseDbEntity {

	@Tfd(value = "MODULE_ID",ddl = "`MODULE_ID` bigint(20) DEFAULT NULL COMMENT '模块id'")
	@ApidocComment("模块id")
	private Long moduleId;

	@Tfd(value = "CONTROLLER_ID",ddl = "`CONTROLLER_ID` bigint(20) DEFAULT NULL COMMENT '控制器id'")
 	@ApidocComment("控制器id")
 	private Long controllerId;

	@Tfd(value = "AUTOR",ddl = "`AUTOR` varchar(50) DEFAULT NULL COMMENT '作者'")
	@ApidocComment("作者")
	@EasyapiOrigin
	private String autor;

	@Tfd(value = "SHOW",ddl = "`SHOW` int(1) DEFAULT 1 COMMENT '是否展示 0-否  1-是'")
	@ApidocComment("是否展示 0-否  1-是")
	@EasyapiOrigin
	private Integer show;

	@Tfd(value = "CONTROLLER_CLASS",ddl = "`CONTROLLER_CLASS` varchar(100) DEFAULT NULL COMMENT '控制器名称'")
	@ApidocComment("控制器名称")
	private String controllerClass;

	@Tfd(value = "METHOD_NAME",ddl = "`METHOD_NAME` varchar(255) DEFAULT NULL COMMENT '接口方法名'")
 	@ApidocComment("接口方法名")
 	private String methodName;

	@Tfd(value = "UNIQUE",ddl = "`UNIQUE` varchar(50) DEFAULT NULL COMMENT '接口唯一标识'")
	@ApidocComment("接口唯一标识")
	@EasyapiOrigin
	private String unique;

	@Tfd(value = "UPGRADE_STATUS",ddl = "`UPGRADE_STATUS` int(1) DEFAULT 0 COMMENT '接口版本  0-最新版本 1-待更新'")
	@ApidocComment("接口版本  0-最新版本 1-待更新")
	private Integer upgradeStatus;

	@Tfd(value = "RENEW_TYPE",ddl = "`RENEW_TYPE` int(1) DEFAULT 0 COMMENT '更新策略: 0-覆盖更新  1-增量更新  2-跳过更新'")
	@ApidocComment("更新策略: 0-覆盖更新  1-增量更新  2-跳过更新")
	private Integer renewType;

	@Tfd(value = "SHOW_NAME",ddl = "`SHOW_NAME` varchar(100) DEFAULT NULL COMMENT '接口标题'")
 	@ApidocComment("接口标题")
	@EasyapiOrigin
 	private String showName;

	@Tfd(value = "PINYIN",ddl = "`PINYIN` varchar(100) DEFAULT NULL COMMENT '接口标题拼音'")
	@ApidocComment("接口标题拼音")
	private String pinyin;

	@Tfd(value = "DESCRIPTION",ddl = "`DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '接口说明'")
 	@ApidocComment("接口说明")
	@EasyapiOrigin
 	private String description;

	@Tfd(value = "REQUEST_URL",ddl = "`REQUEST_URL` varchar(100) DEFAULT NULL COMMENT '请求地址'")
 	@ApidocComment("请求地址")
	@EasyapiOrigin
 	private String requestUrl;

	@Tfd(value = "REQUEST_METHOD",ddl = "`REQUEST_METHOD` int(1) DEFAULT 0 COMMENT '请求方式 0-全部  1-get  2-post'")
 	@ApidocComment("请求方式 0-全部  1-get  2-post ")
	@EasyapiOrigin
 	private Integer requestMethod;

	@Tfd(value = "REQUEST_TYPE",ddl = "`REQUEST_TYPE` int(1) DEFAULT 0 COMMENT '请求体类型 0-form  1-json体  2-文件上传 3-XML 4-RAW'")
 	@ApidocComment("请求体类型 0-form  1-json体  2-文件上传 3-XML 4-RAW")
	@EasyapiOrigin
 	private Integer bodyType;

	@Tfd(value = "SORT",ddl = "`SORT` int(5) DEFAULT 0 COMMENT '排序值'")
 	@ApidocComment("排序值")
 	private Integer sort = 0;

	@Tfd(value = "SOURCE",type = Blob.class,ddl = "`SOURCE` BLOB DEFAULT NULL COMMENT '源代码'")
	@ApidocComment("源代码")
	private String source;

	@Tfd(value = "SEARCH_TAGS",ddl = "`SEARCH_TAGS` varchar(255) DEFAULT NULL COMMENT '搜索字段'")
	@ApidocComment("搜索字段")
	private String searchTags;

	@Tfd(value = "CUSTOM_TAGS",ddl = "`CUSTOM_TAGS` varchar(255) DEFAULT NULL COMMENT '快搜标签'")
	@ApidocComment("快搜标签")
	@EasyapiOrigin
	private String customTags;

	@Tfd(value = "ENABLE_REQ_PACKAGE",ddl = "`ENABLE_REQ_PACKAGE` int(1) DEFAULT 0 COMMENT '是否开启请求参数外包装 0-不是  1-是'")
	@ApidocComment("是否开启请求参数外包装 0-不是  1-是")
	@EasyapiOrigin
	private Integer enableReqPackage;

	@Tfd(value = "ENABLE_RES_PACKAGE",ddl = "`ENABLE_RES_PACKAGE` int(1) DEFAULT 0 COMMENT '是否开启返回参数外包装 0-不是  1-是'")
	@ApidocComment("是否开启返回参数外包装 0-不是  1-是")
	@EasyapiOrigin
	private Integer enableResPackage;

	@Tfd(value = "ORIGIN",type = Blob.class,ddl = "`ORIGIN` BLOB DEFAULT NULL COMMENT '原始数据，用来判断是否被改变的'")
	@ApidocComment("原始数据，用来判断是否被改变的")
	private String origin;

	public void createOrigin(){
		String origin = EasyapiOriginUtil.createOrigin(this);
		this.setOrigin(origin);
	}

	public void mergin(DBModuleInterfaceEntity entity){
		String originStr = entity.getOrigin();
		if(StringUtil.isEmpty(originStr)){
			return ;
		}
		DBModuleInterfaceEntity origin = JsonUtil.jsonToBean(originStr, DBModuleInterfaceEntity.class);
		EasyapiOriginUtil.mergin(this,entity,origin);
		origin.createOrigin();
		entity.setOrigin(origin.getOrigin());
	}

	public static String buildSearchTag(DBModuleInterfaceEntity entity){
		if(entity == null){
			return "";
		}
		StringBuilder sb = new StringBuilder();
		if(!StringUtil.isEmpty(entity.getMethodName())){
			sb.append(entity.getMethodName());
		}
		if(!StringUtil.isEmpty(entity.getShowName())){
			sb.append(entity.getShowName());
		}
		if(!StringUtil.isEmpty(entity.getRequestUrl())){
			sb.append(entity.getRequestUrl());
		}
		if(!StringUtil.isEmpty(entity.getPinyin())){
			sb.append(entity.getPinyin());
		}
		if(sb.length() > 150){
			return sb.substring(0, 150);
		}
		return sb.toString();
	}


	public String getRequestMethodString(){
		if(this.requestMethod == null){
			return "GET";
		}
		switch (requestMethod){
			case 1:	return "GET";
			case 2:	return "POST";
			case 3:	return "PUT";
			case 4:	return "DELETE";
			case 5:	return "HEAD";
			case 6:	return "PATCH";
			case 7:	return "TRACE";
			case 8:	return "OPTIONS";
		}
		return "GET";
	}
	public void setRequestMethod(RequestMethod requestMethod){
		switch (requestMethod){
			case GET:
				this.requestMethod =  1;
				break;
			case DELETE:
				this.requestMethod =  4;
				break;
			case PUT:
				this.requestMethod =  3;
				break;
			case POST:
				this.requestMethod =  2;
				break;
			case HEAD:
				this.requestMethod =  5;
				break;
			case PATCH:
				this.requestMethod =  6;
				break;
			case TRACE:
				this.requestMethod =  7;
				break;
			case OPTIONS:
				this.requestMethod =  8;
				break;
		}
	}

	public Long getModuleId() {
		return moduleId;
	}

	public void setModuleId(Long moduleId) {
		this.moduleId = moduleId;
	}

	public Long getControllerId() {
		return controllerId;
	}

	public void setControllerId(Long controllerId) {
		this.controllerId = controllerId;
	}

	public String getMethodName() {
		return methodName;
	}

	public void setMethodName(String methodName) {
		this.methodName = methodName;
	}

	public String getShowName() {
		return showName;
	}

	public void setShowName(String showName) {
		this.showName = showName;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getRequestUrl() {
		return requestUrl;
	}

	public void setRequestUrl(String requestUrl) {
		this.requestUrl = requestUrl;
	}

	public Integer getRequestMethod() {
		return requestMethod;
	}

	public void setRequestMethod(Integer requestMethod) {
		this.requestMethod = requestMethod;
	}

	public Integer getBodyType() {
		return bodyType;
	}

	public void setBodyType(Integer bodyType) {
		this.bodyType = bodyType;
	}

	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}

	public String getPinyin() {
		return pinyin;
	}

	public void setPinyin(String pinyin) {
		this.pinyin = pinyin;
	}

	public String getSearchTags() {
		return searchTags;
	}

	public void setSearchTags(String searchTags) {
		this.searchTags = searchTags;
	}

	public String getControllerClass() {
		return controllerClass;
	}

	public void setControllerClass(String controllerClass) {
		this.controllerClass = controllerClass;
	}

	public String getUnique() {
		return unique;
	}

	public void setUnique(String unique) {
		this.unique = unique;
	}

	public Integer getUpgradeStatus() {
		return upgradeStatus;
	}

	public void setUpgradeStatus(Integer upgradeStatus) {
		this.upgradeStatus = upgradeStatus;
	}

	public Integer getEnableReqPackage() {
		return enableReqPackage;
	}

	public void setEnableReqPackage(Integer enableReqPackage) {
		this.enableReqPackage = enableReqPackage;
	}

	public Integer getEnableResPackage() {
		return enableResPackage;
	}

	public void setEnableResPackage(Integer enableResPackage) {
		this.enableResPackage = enableResPackage;
	}

	public String getCustomTags() {
		return customTags;
	}

	public void setCustomTags(String customTags) {
		this.customTags = customTags;
	}

	public Integer getShow() {
		return show;
	}

	public void setShow(Integer show) {
		this.show = show;
	}

	public String getAutor() {
		return autor;
	}

	public void setAutor(String autor) {
		this.autor = autor;
	}

	public String getOrigin() {
		return origin;
	}

	public void setOrigin(String origin) {
		this.origin = origin;
	}

	public Integer getRenewType() {
		return renewType;
	}

	public void setRenewType(Integer renewType) {
		this.renewType = renewType;
	}
}