package cn.easyutil.easyapi.entity.db.auth;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;

import java.util.List;

/**
 * 用户
 */
@Tne("EASYAPI_USER")
public class DBUserEntity extends BaseDbEntity {

    @Tfd(value = "ACCOUNT",ddl="`ACCOUNT` varchar(20) DEFAULT NULL COMMENT '账号名'")
    @ApidocComment("账号名")
    private String account;

    @Tfd(value = "PASSWORD",ddl = "`PASSWORD` varchar(50) DEFAULT NULL COMMENT '密码'")
    @ApidocComment("密码")
    private String password;

    @Tfd(value = "MOBILE",ddl = "`MOBILE` varchar(20) DEFAULT NULL COMMENT '手机号码'")
    @ApidocComment("手机号码")
    private String mobile;

    @Tfd(value = "DESCRIPTION",ddl = "`DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '介绍'")
    @ApidocComment("介绍")
    private String description;

    @Tfd(value = "HEADER_IMG",ddl = "`HEADER_IMG` varchar(255) DEFAULT NULL COMMENT '头像'")
    @ApidocComment("头像")
    private String headerImg;

    @Tfd(value = "NICK_NAME",ddl = "`NICK_NAME` varchar(50) DEFAULT NULL COMMENT '昵称'")
    @ApidocComment("昵称")
    private String nickName;

    @Tfd(value = "LAST_LOGIN_TIME",ddl = "`LAST_LOGIN_TIME` bigint(20) DEFAULT NULL COMMENT '上次登陆时间'")
    @ApidocComment("上次登陆时间")
    private Long lastLoginTime;

    @Tfd(value = "DISABLE",ddl = "`DISABLE` int(1) DEFAULT 0 COMMENT '0-未禁用 1-已禁用'")
    @ApidocComment("0-未禁用 1-已禁用")
    private Integer disable;

    @Tfd(value = "SUPER_ADMIN_STATUS",ddl = "`SUPER_ADMIN_STATUS` int(1) DEFAULT 0 COMMENT '是否超级管理员:0-不是  1-是'")
    @ApidocComment("是否超级管理员:0-不是  1-是")
    private Integer superAdminStatus;

    @Tfd(value = "ROLE_ID",ddl = "`ROLE_ID` bigint(20) DEFAULT NULL COMMENT '角色id'")
    @ApidocComment("角色id")
    private Long roleId;

    @Tfd(value = "HIDDEN",ddl = "`HIDDEN` int(1) DEFAULT 0 COMMENT '是否隐藏:0-不隐藏  1-隐藏'")
    @ApidocComment("是否隐藏:0-不隐藏  1-隐藏")
    private Integer hidden;

    @Tfd(value = "LAST_OPEND_INTERFACE_IDS",ddl = "`LAST_OPEND_INTERFACE_IDS` varchar(255) DEFAULT NULL COMMENT '上次打开的接口id集合'")
    @ApidocComment("上次打开的接口id集合")
    private String lastOpendInterfaceIds;

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getHeaderImg() {
        return headerImg;
    }

    public void setHeaderImg(String headerImg) {
        this.headerImg = headerImg;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public Long getLastLoginTime() {
        return lastLoginTime;
    }

    public void setLastLoginTime(Long lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public Integer getDisable() {
        return disable;
    }

    public void setDisable(Integer disable) {
        this.disable = disable;
    }

    public Integer getSuperAdminStatus() {
        return superAdminStatus;
    }

    public void setSuperAdminStatus(Integer superAdminStatus) {
        this.superAdminStatus = superAdminStatus;
    }

    public Long getRoleId() {
        return roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public Integer getHidden() {
        return hidden;
    }

    public void setHidden(Integer hidden) {
        this.hidden = hidden;
    }

    public String getLastOpendInterfaceIds() {
        return lastOpendInterfaceIds;
    }

    public void setLastOpendInterfaceIds(String lastOpendInterfaceIds) {
        this.lastOpendInterfaceIds = lastOpendInterfaceIds;
    }
}
