package cn.easyutil.easyapi.entity.common;

import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import cn.easyutil.easyapi.util.StringUtil;
import org.springframework.web.multipart.MultipartFile;

import java.lang.reflect.Type;
import java.util.*;

/**
 * java类型
 *
 * @author spc
 */
public enum JavaType {

    //1-整数 2-数字 3-布尔 4-字符 5-基本类型数组 6-对象 7-文件 8-map 9-对象数组
    Long(new Class[]{Long.class, long.class}, "整数", 1),
    Integer(new Class[]{Integer.class, int.class}, "整数", 1),
    Double(new Class[]{Double.class, double.class}, "数字", 2),
    Float(new Class[]{Float.class, float.class}, "数字", 2),
    Byte(new Class[]{Byte.class, byte.class}, "整数", 1),
    Boolean(new Class[]{Boolean.class, boolean.class}, "布尔", 3),
    Short(new Class[]{Short.class, short.class}, "整数", 1),
    String(new Class[]{String.class}, "字符", 4),
    Character(new Class[]{Character.class, char.class}, "字符", 4),
    Array(new Class[]{Collection.class}, "基本数组", 5),
    ArrayObject(new Class[]{Collection.class}, "对象数组", 9),
    File(new Class[]{MultipartFile.class}, "文件", 7),
    Map(new Class[]{java.util.Map.class}, "map", 8),
    Object(null, "对象", 6);

    private Class[] javaClass;
    private String remark;
    private Integer type;
    private static final List<JavaType> baseType = Arrays.asList(Long, Integer, Double, Float, Byte, Boolean, Short, Character, String, File, Map);

    JavaType(Class[] javaClass, String remark, Integer type) {
        this.javaClass = javaClass;
        this.remark = remark;
        this.type = type;
    }

    /**
     * 判断是否基本类型，单层结构
     *
     * @param type
     * @return
     */
    public static boolean isBaseType(JavaType type) {
        return baseType.contains(type);
    }

    /**
     * 判断是否基本类型，单层结构
     *
     * @param type
     * @return
     */
    public static boolean isBaseType(Integer type) {
        return isBaseType(getType(type));
    }

    public static JavaType getJavaTypeByClass(Class clazz){
        if(clazz == null){
            return Object;
        }
        for (JavaType javaType : JavaType.values()) {
            Class[] javaClass = javaType.getJavaClass();
            if(javaClass==null || javaClass.length==0){
                continue;
            }
            for (Class aClass : javaClass) {
                if(aClass.isAssignableFrom(clazz)){
                    return javaType;
                }
            }
        }
        return Object;
    }

    /**
     * 根据类型获取说明
     *
     * @param type
     * @return
     */
    public static JavaType getJavaTypeByType(Type type) {
        if(!GenericTypeUtil.isArray(type) && !GenericTypeUtil.isGeneric(type)){
            //非集合或数组类型,也不带有泛型，则直接使用class判断
            return getJavaTypeByClass((Class) type);
        }
        //先处理集合类型
        if(GenericTypeUtil.isArray(type)){
            Class arrayClass = GenericTypeUtil.getArrayGenericClass(type);
           if(isBaseType(getJavaTypeByClass(arrayClass))){
               return Array;
           }
           return ArrayObject;
        }
        //再处理非集合带泛型的类型
        Class ownerClass = GenericTypeUtil.getOwnerClass(type);
        return getJavaTypeByClass(ownerClass);
    }

    public static JavaType getType(Integer type){
        if(StringUtil.isEmpty(type)){
            return null;
        }
        JavaType[] values = JavaType.values();
        for (JavaType value : values) {
            if(value.getType() == type){
                return value;
            }
        }
        return null;
    }

    public boolean alikeClass(Class clazz){
        java.lang.Integer type = getType();
        JavaType[] values = JavaType.values();
        Set<Class> set = new HashSet<>();
        for (JavaType value : values) {
            if(value.getType().equals(type)){
                set.addAll(Arrays.asList(value.getJavaClass()));
            }
        }
        for (Class aClass : set) {
            if(aClass.equals(clazz)){
                return true;
            }
        }
        return false;
    }


    public Class[] getJavaClass() {
        return javaClass;
    }

    public String getRemark() {
        return remark;
    }

    public Integer getType() {
        return type;
    }

}
