package cn.easyutil.easyapi.configuration;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;

/**
 * 单元测试
 */
@Component
@ConfigurationProperties(prefix = "easyapi.unit")
public class EasyapiUnitConfiguration {

    /** 最大并发线程数*/
    private int maxThreadCount = 10;

    /** 超时时间，默认30秒，-1表示永不超时*/
    private Long timeout = 3000L*10;


    public int getMaxThreadCount() {
        return maxThreadCount;
    }

    public void setMaxThreadCount(int maxThreadCount) {
        this.maxThreadCount = maxThreadCount;
    }

    public Long getTimeout() {
        return timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }
}
