package cn.easyutil.easyapi.configuration;

import cn.easyutil.easyapi.EasyapiRun;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import javax.annotation.Resource;

@Configuration
@Import({EasyapiConfiguration.class
        , EasyapiSyncRemoteConfiguration.class
        ,EasyapiDataConfiguration.class
        , EasyapiFilterConfiguration.class
        ,EasyapiUserConfiguration.class
        ,EasyapiUnitConfiguration.class
        ,SpringRunEnvClassComponent.class})
@ConditionalOnProperty(prefix = "easyapi",name = "enable",havingValue = "true")
public class EasyapiAotuConfiguration implements InitializingBean {

    @Resource
    private EasyapiConfiguration configuration;
    @Resource
    private EasyapiDataConfiguration dataConfiguration;
    @Resource
    private EasyapiFilterConfiguration filterConfiguration;
    @Resource
    private EasyapiUserConfiguration userConfiguration;
    @Resource
    private EasyapiSyncRemoteConfiguration syncRemoteConfiguration;
    @Resource
    private ApplicationContext applicationContext;

    @Override
    public void afterPropertiesSet(){
        AllConfiguration all = new AllConfiguration();
        all.setConfiguration(configuration);
        all.setDataConfiguration(dataConfiguration);
        all.setFilterClassConfiguration(filterConfiguration);
        all.setUserConfiguration(userConfiguration);
        all.setSyncRemoteConfiguration(syncRemoteConfiguration);
        //生成接口文档
        EasyapiRun.run(all,applicationContext);
    }
}
