package cn.easyutil.easyapi;

import cn.easyutil.easyapi.configuration.AllConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiConfiguration;
import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.logic.run.DocCreate;
import cn.easyutil.easyapi.logic.run.DocCreatePost;
import cn.easyutil.easyapi.logic.run.DocCreatePre;
import org.springframework.context.ApplicationContext;

public class EasyapiRun {

    public static void run(AllConfiguration all,ApplicationContext appContext){
        EasyapiConfiguration configuration = all.getConfiguration();
        if(!configuration.isEnable()){
            return ;
        }
        try {
            //文档生成前置处理
            DocCreatePre.build(all, appContext).pre();
            DocCreate instance = new DocCreate(all,appContext,ProjectContext.execution);
            if(configuration.isRescan()){
                instance.createApi();
            }
            //文档生成后置处理
            DocCreatePost.build(all, appContext).post();
            System.out.println("*********************************************");
            System.out.println("**********   接口文档已生成 url=/apidoc.html  ***************");
            System.out.println("*********************************************");
        }catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("接口文档生成失败",e);
        }
    }
}
