package cn.easyutil.easyapi.util.http;

import cn.easyutil.easyapi.util.IOUtil;
import cn.easyutil.easyapi.util.JsonUtil;

import java.io.InputStream;
import java.util.Map;

/**
 * http请求的响应结果
 */
public class HttpRes {

    //响应状态码
    private Integer responseCode;

    //响应内容
    private InputStream responseInputStream;

    //响应头
    private Map<String,String> responseHeaders;

    //响应内容
    private String responseMsg;


    public String getResponseMsg(){
        if(responseMsg != null){
            return responseMsg;
        }
        byte[] bytes = IOUtil.inputToByte(this.responseInputStream);
        responseMsg =  new String(bytes);
        return  responseMsg;
    }

    public <T>T getResponseMsg(Class<T> tClass){
        getResponseMsg();
        return JsonUtil.jsonToBean(this.responseMsg, tClass);
    }

    public Integer getResponseCode() {
        return responseCode;
    }

    public void setResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
    }

    public Map<String, String> getResponseHeaders() {
        return responseHeaders;
    }

    public void setResponseHeaders(Map<String, String> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public InputStream getResponseInputStream() {
        return responseInputStream;
    }

    public void setResponseInputStream(InputStream responseInputStream) {
        this.responseInputStream = responseInputStream;
    }
}
