package cn.easyutil.easyapi.service;

import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

public class ProjectService extends DBService<DBProjectEntity> {

    @Resource(name = "easyapiModuleService")
    private ModuleService moduleService;

    @Override
    public void deleteById(Long id) {
        DBProjectEntity project = getById(id);
        if(project == null){
            return ;
        }
        super.deleteById(id);
        DBModuleEntity moduleEntity = new DBModuleEntity();
        moduleEntity.setProjectId(project.getId());
        List<DBModuleEntity> list = moduleService.list(moduleEntity);
        if(list == null){
            return ;
        }
        list.forEach(module -> {
            moduleService.deleteById(module.getId());
        });
    }

    public DBProjectEntity getByName(String name){
        DBProjectEntity entity = new DBProjectEntity();
        entity.setName(name);
        return get(entity);
    }
}
