package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.filter.*;
import cn.easyutil.easyapi.filter.model.DefaultReadJavaBeanApi;
import cn.easyutil.easyapi.filter.model.DefaultReadMockTemplate;
import cn.easyutil.easyapi.filter.model.DefaultReadRequestParamApi;
import cn.easyutil.easyapi.filter.model.DefaultReadResponseParamApi;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.logic.condition.MockProcess;
import cn.easyutil.easyapi.logic.condition.MockProcess2;
import cn.easyutil.easyapi.logic.el.DefaultSpelMethodParser;
import cn.easyutil.easyapi.logic.el.ElExpression;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.StringUtil;
import org.springframework.core.DefaultParameterNameDiscoverer;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.*;

public class MethodParamsCreator {

    private Class clazz;

    private Method method;

    private ApiExtra extra;

    private ReadRequestParamApiFilter reqFilter = new DefaultReadRequestParamApi();

    private ReadResponseParamApiFilter resFilter = new DefaultReadResponseParamApi();

    private ReadJavaBeanApiFilter javaBeanApiFilter = new DefaultReadJavaBeanApi();

    private ReadMockTemplateFilter mockFilter = new DefaultReadMockTemplate(ElExpression.with(DefaultSpelMethodParser.get()));

    private List<DocParamEntity> requestParameters = new ArrayList<>();

    private List<DocParamEntity> returnParameter = new ArrayList<>();

    private String responseMock = "";
    private String requestMock = "";

    private JavaBeanCreator javaBeanCreator;

    public static MethodParamsCreator build(Class clazz,Method method){
        MethodParamsCreator creator = new MethodParamsCreator();
        creator.method = method;
        creator.clazz = clazz;
        return creator;
    }

    public MethodParamsCreator withClass(Class clazz){
        this.clazz = clazz;
        return this;
    }

    public MethodParamsCreator withMockFilter(ReadMockTemplateFilter mockFilter){
        this.mockFilter = mockFilter;
        return this;
    }

    public MethodParamsCreator withReqFilter(ReadRequestParamApiFilter reqFilter){
        this.reqFilter = reqFilter;
        return this;
    }

    public MethodParamsCreator withResFilter(ReadResponseParamApiFilter resFilter){
        this.resFilter = resFilter;
        return this;
    }

    public MethodParamsCreator withBeanFilter(ReadJavaBeanApiFilter beanFilter){
        this.javaBeanApiFilter = beanFilter;
        return this;
    }

    public MethodParamsCreator withBeanCreator(JavaBeanCreator creator){
        this.javaBeanCreator = creator;
        return this;
    }

    public MethodParamsCreator withMethod(Method method){
        this.method = method;
        return this;
    }

    public MethodParamsCreator withExtra(ApiExtra extra){
        this.extra = extra;
        return this;
    }

    public MethodParamsCreator create(){
        try {
            createParameters();
            createReturnType();
            MockProcess2 mocker = MockProcess2.with(mockFilter);
            mocker.setMockArraySize(ProjectContext.allConfiguration.getConfiguration().getMockArraySize());
            Object req = mocker.mockByApiParams(requestParameters);
            Object res = mocker.mockByApiParams(returnParameter);
            requestMock = ObjectUtil.isBaseObject(req)?req.toString():JsonUtil.beanToJson(req);
            responseMock = ObjectUtil.isBaseObject(res)?res.toString():JsonUtil.beanToJson(res);
            return this;
        }catch (Exception e) {
            e.printStackTrace();
            throw new ApidocException("接口参数构建失败:"+clazz.getCanonicalName()+"."+method.getName());
        }
    }

    private void createParameters(){
        extra.setParameter(null);
        Parameter[] parameters = this.method.getParameters();
        DefaultParameterNameDiscoverer discover = new DefaultParameterNameDiscoverer();
        // 实际方法参数形参名称
        String[] parameterNames = discover.getParameterNames(method);
        if(parameters==null || parameters.length==0){
            return ;
        }
        for (int i = 0; i < parameters.length; i++) {
            Parameter parameter = parameters[i];
            Type type = reqFilter.parameterType(parameter,extra);
            Class ownerClass = GenericTypeUtil.getOwnerClass(type);
            extra.setParameter(parameter);

            if(reqFilter.ignore(parameter, type, ownerClass,extra)){
                continue;
            }
            String parameterName = reqFilter.parameterName(parameter,extra);
            if(parameterName == null){
                parameterName = parameterNames[i];
            }
            String description = reqFilter.description(parameter, parameterName,extra);
            if(description == null){
                description = extra.getMethodComment().getParameter(parameterNames[i]).getComment();
            }
            JavaType javaType = JavaType.getJavaTypeByType(type);
            //补充基本信息
            DocParamEntity entity = new DocParamEntity();
            entity.setDescription(description);
            entity.setMockTemplate(reqFilter.mockTemplate(parameter,extra));
            entity.setName(parameterName);
            entity.setRequired(reqFilter.required(parameter,extra)?1:0);
            entity.setShow(reqFilter.show(parameter,extra)?1:0);
            entity.setJavaType(javaType.getType());
            List<DocParamEntity> param = createParam(type, entity);
            this.requestParameters.addAll(param);
        }
    }

    private void createReturnType(){
        extra.setReturnType(null);
        Type returnType = method.getGenericReturnType();
        if(returnType == Void.TYPE){
            return ;
        }
        extra.setReturnType(returnType);
        Class ownerClass = GenericTypeUtil.getOwnerClass(returnType);
        GenericTypeBind bind = GenericTypeUtil.getGenericTypes(returnType);

        //获取自定义类型
        returnType = resFilter.returnType(returnType,ownerClass,bind,extra);
        ownerClass = GenericTypeUtil.getOwnerClass(returnType);
        bind = GenericTypeUtil.getGenericTypes(returnType);

        //判断是否需要忽略
        if(resFilter.ignore(returnType, ownerClass, bind,extra)){
            return ;
        }
        JavaType javaType = JavaType.getJavaTypeByType(returnType);
        DocParamEntity entity = new DocParamEntity();
        entity.setDescription(resFilter.description(method,extra));
        entity.setMockTemplate(resFilter.mockTemplate(method,extra));
        entity.setRequired(resFilter.required(returnType,ownerClass,bind,extra)?1:0);
        entity.setShow(resFilter.show(returnType,ownerClass,bind,extra)?1:0);
        entity.setName(JavaBeanCreator.nullKey);
        entity.setJavaType(javaType.getType());
        returnParameter = createParam(returnType, entity);
    }
    /**
     * 构建参数
     * @param type
     * @param entity
     * @return
     */
    private List<DocParamEntity> createParam(Type type,DocParamEntity entity){
        GenericTypeBind bind = GenericTypeUtil.getGenericTypes(type);
        JavaType javaType = JavaType.getType(entity.getJavaType());
        //已经创建好的bean对象，避免无限递归循环
        Map<String, List<DocParamEntity>> exists = new HashMap<>();
        if(javaType == JavaType.Object){
            return javaBeanCreator.readBean(type,bind,exists);
        }
        entity.setClassName(GenericTypeUtil.getOwnerClass(type).getCanonicalName());
        entity.setJavaType(javaType.getType());
        switch (javaType){
            case Array:{
                entity.setChildren(javaBeanCreator.readArray(type,bind));
                break;
            }
            case ArrayObject:{
                entity.setChildren(javaBeanCreator.readArrayObject(type,bind,exists));
                break;
            }
        }
        Object mockValue = mockFilter.mock(entity.getMockTemplate(), javaType);
        entity.setMockValue(JsonUtil.beanToJson(mockValue));
        return Collections.singletonList(entity);
    }


    public List<DocParamEntity> getRequestParameters() {
        return requestParameters;
    }

    public void setRequestParameters(List<DocParamEntity> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public List<DocParamEntity> getReturnParameter() {
        return returnParameter;
    }

    public void setReturnParameter(List<DocParamEntity> returnParameter) {
        this.returnParameter = returnParameter;
    }

    public String getResponseMock() {
        return responseMock;
    }

    public String getRequestMock() {
        return requestMock;
    }
}
