package cn.easyutil.easyapi.javadoc.html;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.entity.db.doc.*;
import cn.easyutil.easyapi.entity.db.unit.DBSimpleUnitEntity;
import cn.easyutil.easyapi.interview.vo.FindControllerAndInterfaceVo;
import cn.easyutil.easyapi.service.*;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ZipUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;
import org.springframework.util.FileCopyUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * 静态文件创建
 */
@Component
public class StaticDocCreate {

    @javax.annotation.Resource(name = "easyapiUserService")
    private UserService userService;

    @javax.annotation.Resource(name = "easyapiControllerService")
    private ControllerService controllerService;

    @javax.annotation.Resource(name = "easyapiInterfaceService")
    private InterfaceService interfaceService;

    @javax.annotation.Resource(name = "easyapiInterfaceParamService")
    private InterfaceParamService paramService;

    @javax.annotation.Resource(name = "easyapiSimpleUnitService")
    private SimpleUnitService unitService;

    @javax.annotation.Resource(name = "easyapiProjectService")
    private ProjectService projectService;

    @javax.annotation.Resource(name = "easyapiOutPackageService")
    private OutPackageService outPackageService;

    @javax.annotation.Resource(name = "easyapiArticleService")
    private ArticleService articleService;

    /**
     * 导出静态文档
     * @param response
     */
    public void export(HttpServletResponse response) throws UnsupportedEncodingException {
        String basePath = ProjectContext.currentProjectName+"-static-api";
        File zipFile = new File(basePath+"-api"+".zip");
        File root = null;
        if(!zipFile.exists()){
            synchronized (this){
                if(!zipFile.exists()){
                    root = createApiFolder(basePath);
                    toZip(basePath,zipFile);
                }
            }
        }
        response.setContentType("application/octet-stream");
        response.setHeader("Content-disposition","attachment;filename="+ URLEncoder.encode(ProjectContext.currentProjectName+"-apidoc.zip","utf-8"));
        try (FileInputStream in = new FileInputStream(zipFile)){
            byte[] but = new byte[1024*1024];
            int length = 0;
            while((length=in.read(but)) != -1){
                response.getOutputStream().write(but, 0, length);
                response.getOutputStream().flush();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        //最后删除文件
        deepDelFile(zipFile);
        if(root!=null){
            deepDelFile(root);
        }
    }

    private void deepDelFile(File file){
        if(file.isDirectory()){
            File[] files = file.listFiles();
            if(files==null || files.length==0){
                file.delete();
            }else{
                Stream.of(files).forEach(this::deepDelFile);
                file.delete();
            }
        }else{
            file.delete();
        }
    }

    /**
     * 创建文档文件
     */
    private File createApiFolder(String basePath){
        File root = new File(basePath);
        root.delete();
        root.mkdirs();
        //创建基础的文件
        createBaseFiles(basePath);
        //创建数据文件
        try {
            createStaticData(basePath);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return root;
    }

    /**
     * 创建基础文件
     * @param basePath
     */
    private void createBaseFiles(String basePath){
        ResourceLoader resourceLoader = new DefaultResourceLoader();
        //把所有文件全部load一遍，并放入root目录下，然后进行压缩，方便直接下载文件
        saveFile(basePath,resourceLoader.getResource("classpath:static/apidoc.html"));
        saveFile(basePath,resourceLoader.getResource("classpath:static/favicon.ico"));
        saveFile(basePath,resourceLoader.getResource("classpath:static/logo.png"));
        //TODO 设置staticData的版本号
        //setStaticData.version='0.7.5.8'
        //处理css文件
        String cssPath = basePath + File.separator + "css";
        new File(cssPath).mkdirs();
        saveFile(cssPath,resourceLoader.getResource("classpath:static/css/app.57019e4b.css"));
        saveFile(cssPath,resourceLoader.getResource("classpath:static/css/chunk-1c1fed85.5d260265.css"));
        saveFile(cssPath,resourceLoader.getResource("classpath:static/css/chunk-24c11416.f3355718.css"));
        saveFile(cssPath,resourceLoader.getResource("classpath:static/css/chunk-72e1aa5d.421f3289.css"));
        saveFile(cssPath,resourceLoader.getResource("classpath:static/css/chunk-vendors.7e47431c.css"));
        //处理fonts文件
        String fontPath = basePath + File.separator + "fonts";
        new File(fontPath).mkdirs();
        saveFile(fontPath,resourceLoader.getResource("classpath:static/fonts/element-icons.535877f5.woff"));
        saveFile(fontPath,resourceLoader.getResource("classpath:static/fonts/element-icons.732389de.ttf"));
        saveFile(fontPath,resourceLoader.getResource("classpath:static/fonts/iconfont.f40bf2ee.ttf"));
        //处理img
        String imgPath = basePath + File.separator + "img";
        new File(imgPath).mkdirs();
        saveFile(imgPath,resourceLoader.getResource("classpath:static/img/favicon.49b31d60.png"));
        saveFile(imgPath,resourceLoader.getResource("classpath:static/img/logo.8c9f1ac1.png"));
        //处理js
        String jsPath = basePath + File.separator +  "js";
        new File(jsPath).mkdirs();
        saveFile(jsPath,resourceLoader.getResource("classpath:static/js/app.fad1b1a6.js"));
        saveFile(jsPath,resourceLoader.getResource("classpath:static/js/chunk-1c1fed85.8d0e925a.js"));
        saveFile(jsPath,resourceLoader.getResource("classpath:static/js/chunk-7d26b31e.6e42d2f5.js"));
        saveFile(jsPath,resourceLoader.getResource("classpath:static/js/chunk-7e5af5ce.6f5f5395.js"));
        saveFile(jsPath,resourceLoader.getResource("classpath:static/js/chunk-72e1aa5d.4e064600.js"));
        saveFile(jsPath,resourceLoader.getResource("classpath:static/js/chunk-vendors.b6174eff.js"));
    }



    /**
     * 创建数据文件
     * @param basePath
     */
    private void createStaticData(String basePath) throws Exception {
        //静态资源文件
        File dataFile = new File(basePath+File.separator+"StaticData.js");
        List<DBUserEntity> users = userService.list(new DBUserEntity());
        List<DBModuleControllerEntity> controllers = controllerService.list(new DBModuleControllerEntity());
        List<FindControllerAndInterfaceVo> controllerVos = new ArrayList<>();
        if(controllers!=null && !controllers.isEmpty()){
            for (DBModuleControllerEntity controller : controllers) {
                FindControllerAndInterfaceVo vo = new FindControllerAndInterfaceVo();
                BeanUtils.copyProperties(controller,vo);
                DBModuleInterfaceEntity queryIn = new DBModuleInterfaceEntity();
                queryIn.setControllerId(controller.getId());
                vo.setChildren(Optional.ofNullable(interfaceService.list(queryIn)).orElse(Collections.emptyList()));
                controllerVos.add(vo);
            }
        }
        List<DBModuleInterfaceEntity> interfaces = interfaceService.list(new DBModuleInterfaceEntity());
        List<DBInterfaceParamEntity> params = paramService.list(new DBInterfaceParamEntity());
        List<DBSimpleUnitEntity> units = unitService.list(new DBSimpleUnitEntity());
        List<DBModuleOutPackageEntity> packages = outPackageService.list(new DBModuleOutPackageEntity());
        List<DBArticleEntity> articles = articleService.list(new DBArticleEntity());
        DBProjectEntity project = projectService.get(new DBProjectEntity());
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(dataFile)));
        writer.write("var ApiProfile = {");
        writer.newLine();
        writer.write("isStatic: true,");
        writer.newLine();
        writer.write("project: " + JsonUtil.beanToJson(project) +",");
        writer.newLine();
        writer.write("userList: " + JsonUtil.beanToJson(users) +",");
        writer.newLine();
        writer.write("controllerList: " + JsonUtil.beanToJson(controllerVos) +",");
        writer.newLine();
        writer.write("interfaceList: " + JsonUtil.beanToJson(interfaces) +",");
        writer.newLine();
        writer.write("paramList: " + JsonUtil.beanToJson(params) +",");
        writer.newLine();
        writer.write("unitList: " + JsonUtil.beanToJson(units) +",");
        writer.newLine();
        writer.write("paramPackages: " + JsonUtil.beanToJson(packages) +",");
        writer.newLine();
        writer.write("articles: " + JsonUtil.beanToJson(articles) +",");
        writer.newLine();
        writer.write("}");
        writer.flush();
        writer.close();
    }

    private void saveFile(String basePath, Resource resource){
        String filename = basePath+File.separator+resource.getFilename();
        try(InputStream inputStream = resource.getInputStream()) {
            FileCopyUtils.copy(inputStream,new FileOutputStream(new File(filename)));
        }catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 压缩
     * @param folderPath
     * @param zipFile
     */
    private void toZip(String folderPath,File zipFile){
        /** 测试压缩方法1  */
        try (FileOutputStream fos1 = new FileOutputStream(zipFile)){
            ZipUtil.toZip(folderPath, fos1, true);
        }catch (IOException e) {
            e.printStackTrace();
        }
    }

}
