package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.entity.db.doc.*;
import cn.easyutil.easyapi.filter.ReadInterfaceApiFilter;
import cn.easyutil.easyapi.interview.dto.*;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.interview.vo.FindControllerAndInterfaceVo;
import cn.easyutil.easyapi.interview.vo.InterfaceInfoVo;
import cn.easyutil.easyapi.logic.condition.MockProcess2;
import cn.easyutil.easyapi.service.*;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import com.alibaba.fastjson.JSON;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 接口文档接口(简单接口，不需要鉴权)
 *
 * @author spc
 *
 */
@RestController
@ConditionalOnMissingBean(name = "easyapiSimpleApidocController")
@RequestMapping("/easyapi/doc/simple")
public class SimpleApidocController {

    @Resource(name = "easyapiControllerService")
    private ControllerService controllerService;

    @Resource(name = "easyapiInterfaceService")
    private InterfaceService interfaceService;

    @Resource(name = "easyapiInterfaceParamService")
    private InterfaceParamService interfaceParamService;

    @Resource(name = "easyapiHostService")
    private HostService hostService;

    @Resource(name = "easyapiEnvService")
    private EnvService envService;

    @Resource(name = "easyapiHeaderService")
    private HeaderService headerService;

    @Resource(name = "easyapiScriptService")
    private ScriptService scriptService;

    @Resource(name = "easyapiArticleService")
    private ArticleService articleService;

    @Resource(name = "easyapiOutPackageService")
    private OutPackageService outPackageService;

    @Resource(name = "easyapiProjectService")
    private ProjectService projectService;

    @Resource(name = "easyapiUserService")
    private UserService userService;

    @ApidocComment("获取接口控制器列表")
    @PostMapping("/getControllers")
    @AccessAuth(code = 1000)
    public List<FindControllerAndInterfaceVo> getControllers(@RequestBody(required = false) SearchDto dto){
        if(dto == null){
            dto = new SearchDto();
        }
        //key为controllerId，val为interfaceId集合
        Map<Long,List<Long>> controllerAndInterfaceMap = new HashMap<>();
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        DBModuleControllerEntity entity = new DBModuleControllerEntity();
        entity.setModuleId(currentModuleId);
        List<DBModuleControllerEntity> list = controllerService.list(EasyapiBindSQLExecuter.build(entity)
                .setReturnParam(DBModuleControllerEntity::getId)
                .like(!StringUtil.isEmpty(dto),DBModuleControllerEntity::getSearchTags, dto.getSearch())
        );
        if(list != null){
            controllerAndInterfaceMap = list.stream().collect(Collectors.toMap(DBModuleControllerEntity::getId, c -> new ArrayList<>()));
        }
        List<DBModuleInterfaceEntity> inList = interfaceService.list(EasyapiBindSQLExecuter.build(new DBModuleInterfaceEntity())
                .setReturnParam(DBModuleInterfaceEntity::getId,DBModuleInterfaceEntity::getControllerId)
                .like(!StringUtil.isEmpty(dto), DBModuleInterfaceEntity::getSearchTags, dto.getSearch())
        );
        List<DBModuleInterfaceEntity> customList = interfaceService.list(EasyapiBindSQLExecuter.build(new DBModuleInterfaceEntity())
                .setReturnParam(DBModuleInterfaceEntity::getId, DBModuleInterfaceEntity::getControllerId)
                .like(!StringUtil.isEmpty(dto), DBModuleInterfaceEntity::getCustomTags, dto.getSearch())
        );
        final Map<Long,DBModuleInterfaceEntity> inMap = new HashMap<>();
        if(inList == null){
            inList = new ArrayList<>();
        }
        if(customList == null){
            customList = new ArrayList<>();
        }
        inList.addAll(customList);
        inList.forEach(item -> inMap.put(item.getId(),item));
        inList = new ArrayList<>(inMap.values());
        for (DBModuleInterfaceEntity inEntity : inList) {
            Long inId = inEntity.getId();
            Long controllerId = inEntity.getControllerId();
            controllerAndInterfaceMap.computeIfAbsent(controllerId, k -> new ArrayList<>());
            controllerAndInterfaceMap.get(controllerId).add(inId);
        }
        if(controllerAndInterfaceMap.isEmpty()){
            return null;
        }
        List<FindControllerAndInterfaceVo> vos = new ArrayList<>();
        List<DBModuleControllerEntity> controllers = controllerService.list(EasyapiBindSQLExecuter.build(new DBModuleControllerEntity())
                .in(DBModuleControllerEntity::getId, controllerAndInterfaceMap.keySet())
                .orderBy(DBModuleControllerEntity::getSort, true)
                .orderBy(DBModuleControllerEntity::getPinyin,true)
        );
        for (DBModuleControllerEntity controller : controllers) {
            FindControllerAndInterfaceVo vo = new FindControllerAndInterfaceVo();
            BeanUtils.copyProperties(controller,vo);
            List<Long> inIds = controllerAndInterfaceMap.get(controller.getId());
            if(inIds.isEmpty()){
                vos.add(vo);
                continue;
            }
            List<DBModuleInterfaceEntity> children = interfaceService.list(EasyapiBindSQLExecuter.build(new DBModuleInterfaceEntity())
                    .in(DBModuleInterfaceEntity::getId, inIds)
                    .orderBy(DBModuleControllerEntity::getSort, true)
                    .orderBy(DBModuleControllerEntity::getPinyin,true)
            );
            vo.setChildren(Optional.ofNullable(children).orElse(Collections.emptyList()));
            vos.add(vo);
        }
        return vos;
    }

    @ApidocComment("修改控制器信息")
    @PostMapping("/updateControllerInfo")
    @AccessAuth(code = 1000)
    public void updateControllerInfo(@RequestBody DBModuleControllerEntity entity){
        AssertUtil.isNull(entity.getId(), "控制器id不能为空");
        controllerService.update(entity);
        DBModuleControllerEntity query = controllerService.getById(entity.getId());
        query.setSearchTags(DBModuleControllerEntity.buildSearchTag(query));
        controllerService.update(query);
    }

    @ApidocComment("删除控制器信息")
    @PostMapping("/delController")
    @AccessAuth(code = 1000)
    public void delController(@RequestBody IdDto dto){
        controllerService.deleteById(dto.getId());
    }

    @ApidocComment("查询接口列表")
    @PostMapping("/selectInterfaces")
    @AccessAuth(code = 1000)
    public List<DBModuleInterfaceEntity> selectInterfaces(@RequestBody(required = false) SelectInterfacesDto dto){
        DBModuleInterfaceEntity entity = new DBModuleInterfaceEntity();
        entity.setModuleId(CurrentSession.getCurrentModuleId());
        List<DBModuleInterfaceEntity> list = interfaceService.list(EasyapiBindSQLExecuter.build(entity)
                .like(!StringUtil.isEmpty(dto.getSearch()), DBModuleInterfaceEntity::getSearchTags, dto.getSearch())
                .eq(dto.getControllerId() != null, DBModuleInterfaceEntity::getControllerId, dto.getControllerId())
                .orderBy(DBModuleInterfaceEntity::getSort, true)
                .orderBy(DBModuleInterfaceEntity::getPinyin,true)
        );
        return list;
    }

    @ApidocComment("修改接口信息")
    @PostMapping("/updateInterfaces")
    @AccessAuth(code = 1000)
    public void updateInterfaces(@RequestBody InterfaceInfoVo vo){
        if(vo.getInfo() != null){
            AssertUtil.isNull(vo.getInfo().getId(), "接口id不能为空");
            interfaceService.update(vo.getInfo());
            DBModuleInterfaceEntity query = interfaceService.getById(vo.getInfo().getId());
            query.setSearchTags(DBModuleInterfaceEntity.buildSearchTag(query));
            interfaceService.update(query);
        }
        if(vo.getParams() != null){
            AssertUtil.isNull(vo.getParams().getId(), "接口详情id不能为空");
            DBInterfaceParamEntity entity = vo.getParams();
            interfaceParamService.update(entity);
        }

    }

    @ApidocComment("根据接口id获取接口详情信息")
    @PostMapping("/interfaceInfo")
    @AccessAuth(code = 1000)
    public InterfaceInfoVo interfaceInfo(@RequestBody IdDto dto){
        DBModuleInterfaceEntity info = interfaceService.getById(dto.getId());
        AssertUtil.isNull(info, "接口不存在");
        DBInterfaceParamEntity query = new DBInterfaceParamEntity();
        query.setInterfaceId(info.getId());
        DBInterfaceParamEntity params = interfaceParamService.get(query);
        String requestParamJson = params.getRequestParamJson();
        String responseParamJson = params.getResponseParamJson();
        MockProcess2 mocker = MockProcess2.with(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadMockTemplateFilter());
        mocker.setMockArraySize(ProjectContext.allConfiguration.getConfiguration().getMockArraySize());
        if(!StringUtil.isEmpty(requestParamJson)){
            List<DocParamEntity> mockParams = JsonUtil.jsonToList(requestParamJson, DocParamEntity.class);
            Object mock = mocker.mockByApiParams(mockParams);
            params.setRequestMock(JsonUtil.beanToJson(mock));
            params.setRequestParamJson(JsonUtil.beanToJson(mockParams));
        }
        if(!StringUtil.isEmpty(responseParamJson)){
            List<DocParamEntity> mockParams = JsonUtil.jsonToList(responseParamJson, DocParamEntity.class);
            Object mock = mocker.mockByApiParams(mockParams);
            params.setResponseMock(JsonUtil.beanToJson(mock));
            params.setResponseParamJson(JsonUtil.beanToJson(mockParams));
        }
        InterfaceInfoVo vo = new InterfaceInfoVo();
        vo.setInfo(info);
        vo.setParams(params);
        return vo;
    }

    @ApidocComment("删除接口信息")
    @PostMapping("/delInterfaces")
    @AccessAuth(code = 1000)
    public void delInterfaces(@RequestBody IdDto dto){
        interfaceService.deleteById(dto.getId());
    }

    @ApidocComment("获取脚本列表")
    @PostMapping("/getScripts")
    @AccessAuth(code = 1000)
    public List<DBModuleScriptEntity> getScripts(@RequestBody DBModuleScriptEntity query){
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        Long userId = CurrentSession.getCurrentUser().getId();
        List<DBModuleScriptEntity> self = scriptService.list(EasyapiBindSQLExecuter.build(new DBModuleScriptEntity())
                .eq(DBModuleScriptEntity::getModuleId, currentModuleId)
                .eq(DBModuleScriptEntity::getUserId, userId)
                .eq(query.getLocation() != null, DBModuleScriptEntity::getLocation, query.getLocation())
                .orderBy(DBModuleScriptEntity::getSort)
        );
        DBModuleScriptEntity queryGlobal = new DBModuleScriptEntity();
        queryGlobal.setLocation(query.getLocation());
        queryGlobal.setType(1);
        List<DBModuleScriptEntity> global = scriptService.list(queryGlobal);
        return mergin(global,self);
    }

    @ApidocComment("添加全局脚本")
    @PostMapping("/addScript")
    @AccessAuth(code = 1000)
    public void addScript(@RequestBody DBModuleScriptEntity entity){
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        Long userId = CurrentSession.getCurrentUser().getId();
        entity.setModuleId(currentModuleId);
        entity.setUserId(userId);
        scriptService.insert(entity);
    }

    @ApidocComment("修改全局脚本")
    @PostMapping("/updateScript")
    @AccessAuth(code = 1000)
    public void updateScript(@RequestBody DBModuleScriptEntity entity){
        scriptService.update(entity);
    }

    @ApidocComment("删除全局脚本")
    @PostMapping("/delScript")
    @AccessAuth(code = 1000)
    public void delScript(@RequestBody IdDto dto){
        scriptService.deleteById(dto.getId());
    }

    @ApidocComment("获取文章列表")
    @PostMapping("/getArticles")
    @AccessAuth(code = 1000)
    public List<DBArticleEntity> getArticles(){
        return articleService.list(new DBArticleEntity());
    }

    @ApidocComment("获取上次打开的接口集合")
    @PostMapping("/getLastOpendInterfaces")
    @AccessAuth(code = 1000)
    public List<DBModuleInterfaceEntity> getLastOpendInterfaces(){
        String lastOpendInterfaceIds = CurrentSession.getCurrentUser().getLastOpendInterfaceIds();
        if(StringUtil.isEmpty(lastOpendInterfaceIds)){
            return null;
        }
        List<Long> ids = Stream.of(lastOpendInterfaceIds.split(",")).filter(item -> !StringUtil.isEmpty(item)).map(Long::parseLong).collect(Collectors.toList());
        if(ids.isEmpty()){
            return null;
        }
        List<DBModuleInterfaceEntity> interfaces = interfaceService.list(EasyapiBindSQLExecuter.build(new DBModuleInterfaceEntity())
                .in(DBModuleInterfaceEntity::getId, ids)
        );
        List<DBModuleInterfaceEntity> result = new ArrayList<>();
        for (Long id : ids) {
            for (DBModuleInterfaceEntity entity : interfaces) {
                if(entity.getId().equals(id)){
                    result.add(entity);
                }
            }
        }
        return result;
    }

    @ApidocComment("保存已打开的接口集合")
    @PostMapping("/setOpendInterfaceIds")
    @AccessAuth(code = 1000)
    public void setOpendInterfaceIds(@RequestBody IdListDto dto){
        List<Long> ids = dto.getIds();
        String idsStr = "";
        if(ids!=null && !ids.isEmpty()){
            idsStr = ids.stream().map(Objects::toString).collect(Collectors.joining(","));
        }
        DBUserEntity user = new DBUserEntity();
        user.setId(CurrentSession.getCurrentUser().getId());
        user.setLastOpendInterfaceIds(idsStr);
        userService.update(user);
        CurrentSession.getCurrentUser().setLastOpendInterfaceIds(user.getLastOpendInterfaceIds());
    }

    @ApidocComment("获取请求环境列表")
    @PostMapping("/getHosts")
    @AccessAuth(code = 1000)
    public List<DBModuleHostEntity> getHosts(){
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        DBModuleHostEntity entity = new DBModuleHostEntity();
        entity.setModuleId(currentModuleId);
        List<DBModuleHostEntity> list = hostService.list(entity);
        list.sort(Comparator.comparing(DBModuleHostEntity::getCanDelete));
        return list;
    }

    @ApidocComment("添加请求环境")
    @PostMapping("/addHost")
    @AccessAuth(code = 1000)
    public void addHost(@RequestBody DBModuleHostEntity hostEntity){
        hostService.insert(hostEntity);
    }

    @ApidocComment("修改请求环境")
    @PostMapping("/updateHost")
    @AccessAuth(code = 1000)
    public void updateHost(@RequestBody DBModuleHostEntity hostEntity){
        AssertUtil.isNull(hostEntity.getId(), "环境id不能为空");
        hostService.update(hostEntity);
    }

    @ApidocComment("删除请求环境")
    @PostMapping("/delHost")
    @AccessAuth(code = 1000)
    public void delHost(@RequestBody IdDto dto){
        hostService.deleteById(dto.getId());
    }

    @ApidocComment("获取全部环境变量")
    @PostMapping("/getEnvsgs")
    @AccessAuth(code = 1000)
    public List<DBMouduleEnvEntity> getEnvsgs(){
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        DBMouduleEnvEntity entity = new DBMouduleEnvEntity();
        entity.setModuleId(currentModuleId);
        entity.setUserId(CurrentSession.getCurrentUser().getId());
        //自身定义的环境变量
        List<DBMouduleEnvEntity> self = envService.list(entity);
        entity.setUserId(null);
        entity.setType(1);
        List<DBMouduleEnvEntity> global = envService.list(entity);
        return mergin(global,self);
    }

    @ApidocComment("添加环境变量")
    @PostMapping("/addEnv")
    @AccessAuth(code = 1000)
    public void addEnv(@RequestBody DBMouduleEnvEntity env){
        env.setUserId(CurrentSession.getCurrentUser().getId());
        DBMouduleEnvEntity query = new DBMouduleEnvEntity();
        query.setUserId(CurrentSession.getCurrentUser().getId());
        query.setModuleId(CurrentSession.getCurrentModuleId());
        query.setKey(env.getKey());
        query = envService.get(query);
        if(query != null){
            envService.deleteById(query.getId());
        }
        envService.insert(env);
    }

    @ApidocComment("修改环境变量")
    @PostMapping("/updateEnv")
    @AccessAuth(code = 1000)
    public void updateEnv(@RequestBody DBMouduleEnvEntity env){
        AssertUtil.isNull(env.getId(), "环境变量id不能为空");
        DBMouduleEnvEntity query = new DBMouduleEnvEntity();
        query.setUserId(CurrentSession.getCurrentUser().getId());
        query.setModuleId(CurrentSession.getCurrentModuleId());
        query.setKey(env.getKey());
        query = envService.get(query);
        if(query!=null && !query.getId().equals(env.getId())){
            envService.deleteById(query.getId());
        }
        envService.update(env);
    }

    @ApidocComment("删除环境变量")
    @PostMapping("/delEnv")
    @AccessAuth(code = 1000)
    public void delEnv(@RequestBody IdDto dto){
        envService.deleteById(dto.getId());
    }

    @ApidocComment("获取参数的外包装列表")
    @PostMapping("/getOutPackages")
    @AccessAuth(code = 1000)
    public List<DBModuleOutPackageEntity> getOutPackages(@RequestBody GetOutPackagesDto dto){
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        DBModuleOutPackageEntity entity = new DBModuleOutPackageEntity();
        entity.setModuleId(currentModuleId);
        entity.setType(dto.getType());
        List<DBModuleOutPackageEntity> list = outPackageService.list(entity);
        return list;
    }

    @ApidocComment("新增参数的外包装")
    @PostMapping("/addOutPackages")
    @AccessAuth(code = 1000)
    public void addOutPackages(@RequestBody DBModuleOutPackageEntity entity){
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        entity.setModuleId(currentModuleId);
        if(entity.getDefaultStatus() == 1){
            DBModuleOutPackageEntity query = new DBModuleOutPackageEntity();
            query.setModuleId(currentModuleId);
            query.setDefaultStatus(entity.getDefaultStatus());
            query.setType(entity.getType());
            query = outPackageService.get(query);
            AssertUtil.isTrue(query!=null, "外包装只允许有一个包装值");
        }
        String key = entity.getKey();
        DBModuleOutPackageEntity find = new DBModuleOutPackageEntity();
        find.setKey(key);
        find.setType(entity.getType());
        find = outPackageService.get(find);
        if(find != null){
            outPackageService.deleteById(find.getId());
        }
        outPackageService.insert(entity);
    }

    @ApidocComment("修改参数的外包装")
    @PostMapping("/updateOutPackages")
    @AccessAuth(code = 1000)
    public void updateOutPackages(@RequestBody DBModuleOutPackageEntity entity){
        AssertUtil.isNull(entity.getId(), "外包装id不能为空");
        DBModuleOutPackageEntity query = outPackageService.getById(entity.getId());
        if(entity.getDefaultStatus()!=null && entity.getDefaultStatus()==1 && !entity.getDefaultStatus().equals(query.getDefaultStatus())){
            Long currentModuleId = CurrentSession.getCurrentModuleId();
            DBModuleOutPackageEntity find = new DBModuleOutPackageEntity();
            find.setModuleId(currentModuleId);
            find.setDefaultStatus(entity.getDefaultStatus());
            find.setType(entity.getType());
            find = outPackageService.get(query);
            AssertUtil.isTrue(find!=null, "外包装只允许有一个包装值");
        }
        String key = entity.getKey();
        DBModuleOutPackageEntity find = new DBModuleOutPackageEntity();
        find.setKey(key);
        find.setType(entity.getType());
        find = outPackageService.get(find);
        if(find!=null && !find.getId().equals(entity.getId())){
            outPackageService.deleteById(find.getId());
        }
        outPackageService.update(entity);
    }

    @ApidocComment("删除参数的外包装")
    @PostMapping("/delOutPackages")
    @AccessAuth(code = 1000)
    public void delOutPackages(@RequestBody IdDto dto){
        outPackageService.deleteById(dto.getId());
    }

    @ApidocComment("模拟请求")
    @PostMapping("/mock")
    @AccessAuth(code = 1000)
    public Object mock(String path,String tag){
        DBModuleInterfaceEntity interfaceEntity = new DBModuleInterfaceEntity();
        if(!StringUtil.isEmpty(path)){
            interfaceEntity.setRequestUrl(path);
            interfaceEntity = interfaceService.get(interfaceEntity);
        }else{
            List<DBModuleInterfaceEntity> list = Optional.ofNullable(interfaceService.list(new DBModuleInterfaceEntity())).orElse(new ArrayList<>());
            ReadInterfaceApiFilter filter = ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadInterfaceApiFilter();
            for (DBModuleInterfaceEntity in : list) {
                if(filter.verifyMockTag(tag,in)){
                    interfaceEntity = in;
                    break;
                }
            }
        }
        AssertUtil.isNull(interfaceEntity,"未知接口");
        DBInterfaceParamEntity entity = new DBInterfaceParamEntity();
        entity.setInterfaceId(interfaceEntity.getId());
        entity = interfaceParamService.get(entity);
        AssertUtil.isNull(entity,"未知接口");
        MockProcess2 mocker = MockProcess2.with(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadMockTemplateFilter());
        mocker.setMockArraySize(ProjectContext.allConfiguration.getConfiguration().getMockArraySize());
        Object contentMock = mocker.mockByApiParams(entity.getResponseParamJson());

        DBProjectEntity project = new DBProjectEntity();
        project.setId(CurrentSession.getCurrentProjectId());
        project = projectService.get(project);
        if(project==null || project.getEnableResPackage()==0){
            return contentMock;
        }
        if(interfaceEntity.getEnableResPackage() == 0){
            return contentMock;
        }

        DBModuleOutPackageEntity packages = new DBModuleOutPackageEntity();
        packages.setType(1);
        List<DBModuleOutPackageEntity> resPackages = outPackageService.list(packages);
        if(resPackages==null || resPackages.isEmpty()){
            return contentMock;
        }

        Map<String,Object> result = new HashMap<>();
        for (DBModuleOutPackageEntity resPackage : resPackages) {
            if(resPackage.getDefaultStatus() == 1){
                result.put(resPackage.getKey(),contentMock);
            }else{
                result.put(resPackage.getKey(),resPackage.getVal());
            }
        }
        return result;
    }

    @ApidocComment("获取全局header")
    @PostMapping("/getHeaders")
    @AccessAuth(code = 1000)
    public List<DBModuleHeaderEntity> getHeaders(){
        DBModuleHeaderEntity entity = new DBModuleHeaderEntity();
        entity.setUserId(CurrentSession.getCurrentUser().getId());
        entity.setModuleId(CurrentSession.getCurrentModuleId());
        //自身定义的header
        List<DBModuleHeaderEntity> self = headerService.list(entity);
        entity.setUserId(null);
        entity.setType(1);
        //获取全局的header
        List<DBModuleHeaderEntity> gloabel = headerService.list(entity);
        return mergin(self,gloabel);
    }

    @ApidocComment("添加header")
    @PostMapping("/addHeader")
    @AccessAuth(code = 1000)
    public void addHeader(@RequestBody DBModuleHeaderEntity entity){
        entity.setUserId(CurrentSession.getCurrentUser().getId());
        entity.setModuleId(CurrentSession.getCurrentModuleId());
        AssertUtil.isEmpty(entity.getKey(),"key不能为空");
        AssertUtil.isEmpty(entity.getVal(),"val不能为空");
        DBModuleHeaderEntity query = new DBModuleHeaderEntity();
        query.setUserId(CurrentSession.getCurrentUser().getId());
        query.setModuleId(CurrentSession.getCurrentModuleId());
        query.setKey(entity.getKey());
        query = headerService.get(query);
        if(query != null){
            headerService.deleteById(query.getId());
        }
        headerService.insert(entity);
    }

    @ApidocComment("删除header")
    @PostMapping("/delHeader")
    @AccessAuth(code = 1000)
    public void delHeader(@RequestBody IdDto dto){
        headerService.deleteById(dto.getId());
    }

    @ApidocComment("修改header")
    @PostMapping("/updateHeader")
    @AccessAuth(code = 1000)
    public void updateHeader(@RequestBody DBModuleHeaderEntity entity){
        AssertUtil.isNull(entity.getId(),"id不能为空");
        DBModuleHeaderEntity query = new DBModuleHeaderEntity();
        query.setUserId(CurrentSession.getCurrentUser().getId());
        query.setModuleId(CurrentSession.getCurrentModuleId());
        query.setKey(entity.getKey());
        query = headerService.get(query);
        if(query!=null && !query.getId().equals(entity.getId())){
            headerService.deleteById(query.getId());
        }
        headerService.update(entity);
    }

    /**
     * 合并
     * @param li1
     * @param li2
     * @param <T>
     * @return
     */
    private <T extends BaseDbEntity> List<T> mergin(List<T> li1,List<T> li2){
        if(li1 == null){
            li1 = new ArrayList<>();
        }
        if(li2 == null){
            li2 = new ArrayList<>();
        }
        //利用set去重
        Set<Long> ids = new HashSet<>();
        List<T> result = new ArrayList<>();
        li1.addAll(li2);
        for (T t : li1) {
            boolean add = ids.add(t.getId());
            if(add){
                result.add(t);
            }
        }
        return result;
    }
}
