package cn.easyutil.easyapi.interview.controller;


import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.auth.AuthMoudleParseBean;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.auth.AuthMoudle;
import cn.easyutil.easyapi.entity.db.auth.DBRoleAuthEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserTemporaryAuthEntity;
import cn.easyutil.easyapi.interview.dto.BindProjectsDto;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.dto.UpdateRolesDto;
import cn.easyutil.easyapi.interview.dto.UpdateUserAuthCodesDto;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.interview.session.SessionUser;
import cn.easyutil.easyapi.interview.vo.GetRolesByUserIdVo;
import cn.easyutil.easyapi.service.RoleAuthService;
import cn.easyutil.easyapi.service.RoleProjectService;
import cn.easyutil.easyapi.service.RoleService;
import cn.easyutil.easyapi.service.UserTemporaryAuthService;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.StringUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@RestController
@ConditionalOnMissingBean(name = "easyapiRoleAuthController")
@RequestMapping("/easyapi/doc/role")
public class RoleAuthController {

    @Resource(name = "easyapiRoleService")
    private RoleService roleService;

    @Resource(name = "easyapiRoleAuthService")
    private RoleAuthService authService;

    @Resource(name = "easyapiRoleProjectService")
    private RoleProjectService roleProjectService;

    @Resource(name = "easyapiUserTemporaryAuthService")
    private UserTemporaryAuthService userTemporaryAuthService;

    @ApidocComment("获取角色列表")
    @PostMapping("/getRoles")
    @AccessAuth(code = 1000)
    public List<DBRoleEntity> getRoles(){
        SessionUser currentUser = CurrentSession.getCurrentUser();
        List<DBRoleEntity> list = roleService.list(EasyapiBindSQLExecuter.build(new DBRoleEntity()).eq(!StringUtil.isEmpty(currentUser.getRoleId()), DBRoleEntity::getId, currentUser.getRoleId()));
        return list;
    }

    @ApidocComment("获取指定用户的权限码")
    @AccessAuth(code = 1000)
    public List<GetRolesByUserIdVo> getRolesByUserId(@RequestBody IdDto dto){
        Long id = dto.getId();
        DBUserTemporaryAuthEntity auth = new DBUserTemporaryAuthEntity();
        auth.setUserId(id);
        List<DBUserTemporaryAuthEntity> authCodes = userTemporaryAuthService.list(auth);
        List<Integer> allCodes = AuthMoudle.allCode();
        List<GetRolesByUserIdVo> vos = new ArrayList<>();
        for (Integer code : allCodes) {
            GetRolesByUserIdVo vo = new GetRolesByUserIdVo();
            vo.setAuthCode(code);
            vo.setCodeName(AuthMoudle.getByCode(code).getMoudleRemark());
            if(authCodes==null || authCodes.isEmpty()){
                vos.add(vo);
                continue;
            }
            DBUserTemporaryAuthEntity entity = authCodes.stream().filter(ac -> code.equals(ac.getAuthCode())).findFirst().orElse(null);
            if(entity != null){
                vo.setChecked(true);
            }
            vos.add(vo);
        }
        return vos;
    }

    @ApidocComment("修改指定用户的权限码")
    @AccessAuth(code = 1000)
    public void updateUserAuthCodes(@RequestBody UpdateUserAuthCodesDto dto){
        Long userId = dto.getUserId();
        List<Integer> codes = dto.getCodes();
        userTemporaryAuthService.delByUserId(userId);
        if(codes==null || codes.size()==0){
            return ;
        }
        List<DBUserTemporaryAuthEntity> auths = new ArrayList<>();
        for (Integer code : codes) {
            DBUserTemporaryAuthEntity auth = new DBUserTemporaryAuthEntity();
            auth.setUserId(userId);
            auth.setAuthCode(code);
            auths.add(auth);
        }
        userTemporaryAuthService.insertAny(auths);
    }

    @ApidocComment("修改角色信息")
    @PostMapping("/updateRoles")
    @AccessAuth(code = 1000)
    public void updateRoles(@RequestBody UpdateRolesDto dto){
        AssertUtil.isNull(dto.getId(), "角色id不能为空");
        DBRoleEntity entity = new DBRoleEntity();
        BeanUtils.copyProperties(dto, entity);
        roleService.update(entity);
        if(dto.getAuthCodes() == null){
            return ;
        }
        //先删除旧的权限
        authService.delByRoleId(dto.getId());
        //添加新的权限
        for (Integer authCode : dto.getAuthCodes()) {
            DBRoleAuthEntity auth = new DBRoleAuthEntity();
            auth.setAuthCode(authCode);
            auth.setRoleId(dto.getId());
            authService.insert(auth);
        }
    }

    @ApidocComment("添加角色信息")
    @PostMapping("/addRoles")
    @AccessAuth(code = 1000)
    public void addRoles(@RequestBody UpdateRolesDto dto){
        DBRoleEntity entity = new DBRoleEntity();
        BeanUtils.copyProperties(dto, entity);
        roleService.insert(entity);
        if(dto.getAuthCodes() == null){
            return ;
        }
        //添加新的权限
        for (Integer authCode : dto.getAuthCodes()) {
            DBRoleAuthEntity auth = new DBRoleAuthEntity();
            auth.setAuthCode(authCode);
            auth.setRoleId(dto.getId());
            authService.insert(auth);
        }
    }

    @ApidocComment("删除角色信息")
    @PostMapping("/delRoles")
    @AccessAuth(code = 1000)
    public void delRole(@RequestBody IdDto dto){
        roleService.deleteById(dto.getId());
        authService.delByRoleId(dto.getId());
    }

    //---------------------角色权限
    @ApidocComment("获取全部权限码")
    @PostMapping("/getAuthCodes")
    @AccessAuth(code = 1000)
    public List<AuthMoudleParseBean> getAuthCodes(){
        List<AuthMoudle> all = AuthMoudle.allMoudle(CurrentSession.getCurrentUser().getProjectIds().get(CurrentSession.getCurrentProjectId()));
        List<AuthMoudleParseBean> parses = new ArrayList<>();
        for (AuthMoudle authMoudle : all) {
            AuthMoudleParseBean parse = new AuthMoudleParseBean();
            parse.setAuthCode(authMoudle.getAuthCode());
            parse.setMoudleName(authMoudle.getMoudleName());
            parse.setMoudleRemark(authMoudle.getMoudleRemark());
            parses.add(parse);
        }
        return parses;
    }


    @ApidocComment("获取角色绑定的项目列表")
    @PostMapping("/getRoleProjects")
    @AccessAuth(code = 1000)
    public List<DBRoleProjectEntity> getRoleProjects(@RequestBody IdDto dto){
        SessionUser currentUser = CurrentSession.getCurrentUser();
        if(currentUser.getSuperAdminStatus() != 1){
            dto.setId(currentUser.getRoleId());
        }
        List<DBRoleProjectEntity> list = roleProjectService.getByRoleId(dto.getId());
        return list;
    }

    @ApidocComment("修改角色绑定项目列表")
    @PostMapping("/bindProjects")
    @AccessAuth(code = 1000)
    public void bindProjects(@RequestBody BindProjectsDto dto){
        AssertUtil.isNull(dto.getRoleId(), "角色id不能为空");
        AssertUtil.isNull(dto.getProjectIds(), "项目id集合不能为空");

        //先删除
        roleProjectService.delByRoleId(dto.getRoleId());
        //再绑定
        for (Long projectId : dto.getProjectIds()) {
            DBRoleProjectEntity entity = new DBRoleProjectEntity();
            entity.setRoleId(dto.getRoleId());
            entity.setProjectId(projectId);
            roleProjectService.insert(entity);
        }
    }
}
