package cn.easyutil.easyapi.filter.model;

import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.ReadRequestParamApiFilter;
import cn.easyutil.easyapi.logic.creator.CreatorCommonMethod;
import cn.easyutil.easyapi.util.AnnotationUtil;
import cn.easyutil.easyapi.util.StringUtil;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.*;

/**
 * 读取请求参数相关的api
 *
 */
public class DefaultReadRequestParamApi extends ReadRequestParamApiFilter {

    private List<Class> ignoreClass = Arrays.asList(HttpServletRequest.class,HttpServletResponse.class);

    @Override
    public boolean ignore(Parameter parameter, Type parameterType, Class parameterClass, ApiExtra extra) {
        return getIgnoredClasses().contains(parameterClass);
    }

    @Override
    public String parameterName(Parameter parameter, ApiExtra extra) {
        RequestParam param = parameter.getDeclaredAnnotation(RequestParam.class);
        if(param == null){
            return null;
        }
        if (!StringUtil.isEmpty(param.value())) {
            return param.value();
        }
//        这个default有问题，一堆符号
//        if (!StringUtil.isEmpty(param.defaultValue())) {
//            return param.defaultValue();
//        }
        return null;
    }

    @Override
    public Type parameterType(Parameter parameter, ApiExtra extra) {
        return parameter.getParameterizedType();
    }

    @Override
    public String description(Parameter parameter,String parameterName, ApiExtra extra) {
        ApidocComment apidocComment = parameter.getDeclaredAnnotation(ApidocComment.class);
        if(apidocComment != null){
            return apidocComment.value();
        }
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiImplicitParams", parameter.getAnnotations());
        if(annotation == null){
            return "";
        }
        Object value = AnnotationUtil.getAnnotationValue(annotation, "value");
        if(value==null || !value.getClass().isArray()){
            return "";
        }
        int length = Array.getLength(value);
        for (int i = 0; i < length; i++) {
            Object o = Array.get(value, i);
            if(!o.getClass().isAnnotation()){
                continue;
            }
            String name = AnnotationUtil.getAnnotationValue((Annotation) o, "name").toString();
            if(parameterName.equals(name)){
                return AnnotationUtil.getAnnotationValue((Annotation) o, "value").toString();
            }
        }
        return null;
    }

    @Override
    public String mockTemplate(Parameter parameter, ApiExtra extra) {
        return CreatorCommonMethod.mockTemplate(parameter.getAnnotations());
    }

    @Override
    public boolean required(Parameter parameter, ApiExtra extra) {
        return false;
    }

    @Override
    public boolean show(Parameter parameter, ApiExtra extra) {
        return true;
    }

    @Override
    public List<String> conditons(Parameter parameter, ApiExtra extra) {
        Annotation[] annotations = parameter.getAnnotations();
        return CreatorCommonMethod.readConditons(annotations);
    }

    protected List<Class> getIgnoredClasses(){
        return ignoreClass;
    }
}
