package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;

import java.sql.Blob;

/**
 * 参数类
 */
@Tne("EASYAPI_PARAM")
public class DBParamEntity extends BaseDbEntity {

	@Tfd(value = "MODULE_ID",ddl = "`MODULE_ID` bigint(20) DEFAULT NULL COMMENT '模块id'")
	@ApidocComment("模块id")
	private Long moduleId;

	@Tfd(value = "CLASS_NAME",ddl = "`CLASS_NAME` varchar(100) DEFAULT NULL COMMENT '包名+类名'")
 	@ApidocComment("包名+类名")
 	private String className;

	@Tfd(value = "NAME",ddl = "`NAME` varchar(50) DEFAULT NULL COMMENT '字段名称'")
 	@ApidocComment("字段名称")
 	private String name;

	@Tfd(value = "DESCRIPTION",ddl = "`DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '参数说明'")
 	@ApidocComment("字段说明")
 	private String description;

	/**
	 * @see cn.easyutil.easyapi.entity.common.JavaType
	 */
	@Tfd(value = "JAVA_TYPE",ddl = "`JAVA_TYPE` int(2) DEFAULT 0 COMMENT '参照javaType'")
 	@ApidocComment("参照javaType")
 	private Integer javaType;

	@Tfd(value = "MOCK_VALUE",ddl = "`MOCK_VALUE` varchar(255) DEFAULT NULL COMMENT '根据template生成的值'")
 	@ApidocComment("根据template生成的值")
 	private String mockValue;

	@Tfd(value = "MOCK_TEMPLATE",ddl = "`MOCK_TEMPLATE` varchar(255) DEFAULT NULL COMMENT '原始未被替换的mockvalue的值'")
 	@ApidocComment("原始未被替换的mockvalue的值")
 	private String mockTemplate;

	@Tfd(value = "CONDITION_TEMPLATE",ddl = "`CONDITION_TEMPLATE` varchar(255) DEFAULT NULL COMMENT '参数的校验值，多条逗号分隔'")
	@ApidocComment("参数的校验值，多条逗号分隔")
	private String conditionTemplate;

	@Tfd(value = "REQUIRED",ddl = "`REQUIRED` int(1) DEFAULT 0 COMMENT '是否必填 0-不必填  1-必填'")
 	@ApidocComment("是否必填 0-不必填  1-必填")
 	private Integer required;

	@Tfd(value = "SHOW",ddl = "`SHOW` int(1) DEFAULT 0 COMMENT '是否显示  0-不显示  1-显示'")
 	@ApidocComment("是否显示  0-不显示  1-显示")
 	private Integer show;

	@Tfd(value = "PARENT_ID",ddl = "`PARENT_ID` bigint(20) DEFAULT NULL COMMENT '父参数id'")
	@ApidocComment("父参数id")
	private Long parentId;

	@Tfd(value = "PARENT_CLASS",ddl = "`PARENT_CLASS` varchar(255) DEFAULT NULL COMMENT '父参数类型'")
	@ApidocComment("父参数类型")
	private String parentClass;

	@Tfd(value = "SOURCE",type = Blob.class,ddl = "`SOURCE` BLOB DEFAULT NULL COMMENT '源代码'")
	@ApidocComment("源代码")
	private String source;

	public Long getModuleId() {
		return moduleId;
	}

	public void setModuleId(Long moduleId) {
		this.moduleId = moduleId;
	}

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Integer getJavaType() {
		return javaType;
	}

	public void setJavaType(Integer javaType) {
		this.javaType = javaType;
	}

	public String getMockValue() {
		return mockValue;
	}

	public void setMockValue(String mockValue) {
		this.mockValue = mockValue;
	}

	public String getMockTemplate() {
		return mockTemplate;
	}

	public void setMockTemplate(String mockTemplate) {
		this.mockTemplate = mockTemplate;
	}

	public Integer getRequired() {
		return required;
	}

	public void setRequired(Integer required) {
		this.required = required;
	}

	public Integer getShow() {
		return show;
	}

	public void setShow(Integer show) {
		this.show = show;
	}

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}

	public String getParentClass() {
		return parentClass;
	}

	public void setParentClass(String parentClass) {
		this.parentClass = parentClass;
	}

	public String getConditionTemplate() {
		return conditionTemplate;
	}

	public void setConditionTemplate(String conditionTemplate) {
		this.conditionTemplate = conditionTemplate;
	}
}