package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;

/**
 * 模块环境变量配置
 */
@Tne("EASYAPI_MODULE_ENV")
public class DBMouduleEnvEntity extends BaseDbEntity {

    @Tfd(value = "MODULE_ID",ddl = "`MODULE_ID` bigint(20) DEFAULT NULL COMMENT '模块id'")
    @ApidocComment("模块id")
    private Long moduleId;

    @Tfd(value = "USER_ID",ddl = "`USER_ID` bigint(20) DEFAULT NULL COMMENT '用户id'")
    @ApidocComment("用户id")
    private Long userId;

    @Tfd(value = "TYPE",ddl = "`TYPE` int(1) DEFAULT 0 COMMENT '类型  0-私有 1-共有'")
    @ApidocComment("类型  0-私有 1-共有")
    private Integer type;

    @Tfd(value = "NAME",ddl = "`NAME` varchar(50) DEFAULT NULL COMMENT '环境变量名称'")
    @ApidocComment("环境变量名称")
    private String name;

    @Tfd(value = "KEY",ddl = "`KEY` varchar(100) DEFAULT NULL COMMENT '环境变量key'")
    @ApidocComment("环境变量key")
    private String key;

    @Tfd(value = "VAL",ddl = "`VAL` varchar(255) DEFAULT NULL COMMENT '环境变量val'")
    @ApidocComment("环境变量val")
    private String val;

    public Long getModuleId() {
        return moduleId;
    }

    public void setModuleId(Long moduleId) {
        this.moduleId = moduleId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getVal() {
        return val;
    }

    public void setVal(String val) {
        this.val = val;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}
