package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.util.StringUtil;

import java.sql.Blob;

/**
 * 控制器
 */
@Tne("EASYAPI_MODULE_CONTROLLER")
public class DBModuleControllerEntity extends BaseDbEntity {

	@Tfd(value = "MODULE_ID",ddl = "`MODULE_ID` bigint(20) DEFAULT NULL COMMENT '所属模块id'")
	@ApidocComment("所属模块id")
	private Long moduleId;

	@Tfd(value = "CLASS_NAME",ddl = "`CLASS_NAME` varchar(100) DEFAULT 0 COMMENT '控制器全类名'")
 	@ApidocComment("控制器全类名")
 	private String className;

	@Tfd(value = "SHOW_NAME",ddl = "`SHOW_NAME` varchar(100) DEFAULT NULL COMMENT '控制器名称'")
	@ApidocComment("控制器名称")
 	private String showName;

	@Tfd(value = "DESCRIPTION",ddl = "`DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '控制器说明'")
	@ApidocComment("控制器说明")
	private String description;

	@Tfd(value = "AUTHOR",ddl = "`AUTHOR` varchar(20) DEFAULT NULL COMMENT '控制器作者'")
	@ApidocComment("控制器作者")
	private String author;

	@Tfd(value = "PINYIN",ddl = "`PINYIN` varchar(255) DEFAULT NULL COMMENT '控制器名称拼音'")
	@ApidocComment("控制器名称拼音")
 	private String pinyin;

	@Tfd(value = "API_PATH",ddl = "`API_PATH` varchar(50) DEFAULT NULL COMMENT '统一请求的父路径'")
 	@ApidocComment("统一请求的父路径")
 	private String apiPath;

	@Tfd(value = "SORT",ddl = "`SORT` int(5) DEFAULT 0 COMMENT '排序值,值越小，排名越靠前'")
 	@ApidocComment("排序值,值越小，排名越靠前")
 	private Integer sort = 0;

	@Tfd(value = "SOURCE",type = Blob.class,ddl = "`SOURCE` BLOB DEFAULT NULL COMMENT '源代码'")
	@ApidocComment("源代码")
	private String source;

	@Tfd(value = "SEARCH_TAGS",ddl = "`SEARCH_TAGS` varchar(255) DEFAULT NULL COMMENT '搜索字段'")
	@ApidocComment("搜索字段")
	private String searchTags;

	public static String buildSearchTag(DBModuleControllerEntity entity){
		if(entity == null){
			return "";
		}
		StringBuilder sb = new StringBuilder();
		if(!StringUtil.isEmpty(entity.getShowName())){
			sb.append(entity.getShowName());
		}
		if(!StringUtil.isEmpty(entity.getApiPath())){
			sb.append(entity.getApiPath());
		}
		if(!StringUtil.isEmpty(entity.getAuthor())){
			sb.append(entity.getAuthor());
		}
		if(!StringUtil.isEmpty(entity.getPinyin())){
			sb.append(entity.getPinyin());
		}
		return sb.toString();
	}

	public Long getModuleId() {
		return moduleId;
	}

	public void setModuleId(Long moduleId) {
		this.moduleId = moduleId;
	}

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}

	public String getShowName() {
		return showName;
	}

	public void setShowName(String showName) {
		this.showName = showName;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getAuthor() {
		return author;
	}

	public void setAuthor(String author) {
		this.author = author;
	}

	public String getPinyin() {
		return pinyin;
	}

	public void setPinyin(String pinyin) {
		this.pinyin = pinyin;
	}

	public String getApiPath() {
		return apiPath;
	}

	public void setApiPath(String apiPath) {
		this.apiPath = apiPath;
	}

	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}


	public String getSearchTags() {
		return searchTags;
	}

	public void setSearchTags(String searchTags) {
		this.searchTags = searchTags;
	}
}