package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;

import java.sql.Blob;

/**
 * 接口参数
 */
@Tne("EASYAPI_INTERFACE_PARAM")
public class DBInterfaceParamEntity extends BaseDbEntity {

    @Tfd(value = "INTERFACE_ID",ddl="`INTERFACE_ID` bigint(20) DEFAULT NULL COMMENT '接口id'")
    @ApidocComment("接口id")
    private Long interfaceId;

    @Tfd(value = "REQUEST_DESCRIPTION",ddl = "`REQUEST_DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '请求参数说明'")
    @ApidocComment("请求参数说明")
    private String requestParamRemark;

    @Tfd(value = "RESPONSE_DESCRIPTION",ddl = "`RESPONSE_DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '响应参数说明'")
    @ApidocComment("响应参数说明")
    private String responseParamRemark;

    @Tfd(value = "REQUEST_PARAM_JSON",type = Blob.class,ddl = "`REQUEST_PARAM_JSON` BLOB DEFAULT NULL COMMENT '请求参数详情json'")
    @ApidocComment("请求参数详情json")
    private String requestParamJson;

    @Tfd(value = "RESPONSE_PARAM_JSON",type = Blob.class,ddl = "`RESPONSE_PARAM_JSON` BLOB DEFAULT NULL COMMENT '响应参数详情json'")
    @ApidocComment("响应参数详情json")
    private String responseParamJson;

    @Tfd(value = "RESPONSE_MOCK",type = Blob.class,ddl = "`RESPONSE_MOCK` BLOB DEFAULT NULL COMMENT '响应结果mock'")
    @ApidocComment("接口mock")
    private String responseMock;

    @Tfd(value = "REQUEST_MOCK",type = Blob.class,ddl = "`REQUEST_MOCK` BLOB DEFAULT NULL COMMENT '请求参数mock'")
    @ApidocComment("接口mock")
    private String requestMock;

    public Long getInterfaceId() {
        return interfaceId;
    }

    public void setInterfaceId(Long interfaceId) {
        this.interfaceId = interfaceId;
    }

    public String getRequestParamRemark() {
        return requestParamRemark;
    }

    public void setRequestParamRemark(String requestParamRemark) {
        this.requestParamRemark = requestParamRemark;
    }

    public String getResponseParamRemark() {
        return responseParamRemark;
    }

    public void setResponseParamRemark(String responseParamRemark) {
        this.responseParamRemark = responseParamRemark;
    }

    public String getRequestParamJson() {
        return requestParamJson;
    }

    public void setRequestParamJson(String requestParamJson) {
        this.requestParamJson = requestParamJson;
    }

    public String getResponseParamJson() {
        return responseParamJson;
    }

    public void setResponseParamJson(String responseParamJson) {
        this.responseParamJson = responseParamJson;
    }

    public String getResponseMock() {
        return responseMock;
    }

    public void setResponseMock(String responseMock) {
        this.responseMock = responseMock;
    }

    public String getRequestMock() {
        return requestMock;
    }

    public void setRequestMock(String requestMock) {
        this.requestMock = requestMock;
    }
}
