package cn.easyutil.easyapi.entity.db.auth;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;

import java.sql.Blob;

/**
 * 项目
 */
@Tne("EASYAPI_PROJECT")
public class DBProjectEntity extends BaseDbEntity {

    @Tfd(value = "TITLE",ddl="`TITLE` varchar(100) DEFAULT NULL COMMENT '项目标题'")
    @ApidocComment("项目标题")
    private String title;

    @Tfd(value = "NAME",ddl = "`NAME` varchar(100) DEFAULT NULL COMMENT '项目名称'")
    @ApidocComment("项目名称")
    private String name;

    @Tfd(value = "INDEX_BANNER",type = Blob.class,ddl = "`INDEX_BANNER` BLOB DEFAULT NULL COMMENT '项目首页广告内容'")
    @ApidocComment("项目首页广告内容")
    private String indexBanner;

    @Tfd(value = "DESCRIPTION",type = Blob.class,ddl = "`DESCRIPTION` BLOB DEFAULT NULL COMMENT '项目介绍'")
    @ApidocComment("项目介绍")
    private String description;

    @Tfd(value = "IMGS",type = Blob.class,ddl = "`IMGS` BLOB DEFAULT NULL COMMENT '项目图片'")
    @ApidocComment("项目图片")
    private String imgs;

    @Tfd(value = "DISABLE",ddl = "`DISABLE` int(1) DEFAULT 0 COMMENT '项目状态:0-正常  1-关闭'")
    @ApidocComment("项目状态:0-正常  1-关闭")
    private Integer disable;

    @Tfd(value = "DEFAULT_STATUS",ddl="`DEFAULT_STATUS` int(1) DEFAULT 0 COMMENT '是否默认项目 0-不是  1-是'")
    @ApidocComment("是否默认项目 0-不是  1-是")
    private Integer defaultStatus;

    @Tfd(value = "ENABLE_REQ_PACKAGE",ddl = "`ENABLE_REQ_PACKAGE` int(1) DEFAULT 0 COMMENT '是否开启请求参数外包装 0-否  1-是'")
    @ApidocComment("是否开启请求参数外包装 0-不是  1-是")
    private Integer enableReqPackage;

    @Tfd(value = "ENABLE_RES_PACKAGE",ddl = "`ENABLE_RES_PACKAGE` int(1) DEFAULT 0 COMMENT '是否开启返回参数外包装 0-否  1-是'")
    @ApidocComment("是否开启返回参数外包装 0-不是  1-是")
    private Integer enableResPackage;

    @Tfd(value = "ENABLE_ONLY_REQUESTURL",ddl = "`ENABLE_ONLY_REQUESTURL` int(1) DEFAULT 0 COMMENT '是否开启统一接口路径 0-不是  1-是 0-否  1-是'")
    @ApidocComment("是否开启统一接口路径 0-不是  1-是")
    private Integer enableOnlyRequestUrl;

    @Tfd(value = "ONLY_REQUESTURL",ddl = "`ONLY_REQUESTURL` varchar(255) DEFAULT NULL COMMENT '统一接口路径地址'")
    @ApidocComment("统一接口路径地址")
    private String onlyRequestUrl;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getImgs() {
        return imgs;
    }

    public void setImgs(String imgs) {
        this.imgs = imgs;
    }

    public Integer getDisable() {
        return disable;
    }

    public void setDisable(Integer disable) {
        this.disable = disable;
    }

    public Integer getDefaultStatus() {
        return defaultStatus;
    }

    public void setDefaultStatus(Integer defaultStatus) {
        this.defaultStatus = defaultStatus;
    }

    public String getIndexBanner() {
        return indexBanner;
    }

    public void setIndexBanner(String indexBanner) {
        this.indexBanner = indexBanner;
    }

    public Integer getEnableReqPackage() {
        return enableReqPackage;
    }

    public void setEnableReqPackage(Integer enableReqPackage) {
        this.enableReqPackage = enableReqPackage;
    }

    public Integer getEnableResPackage() {
        return enableResPackage;
    }

    public void setEnableResPackage(Integer enableResPackage) {
        this.enableResPackage = enableResPackage;
    }

    public Integer getEnableOnlyRequestUrl() {
        return enableOnlyRequestUrl;
    }

    public void setEnableOnlyRequestUrl(Integer enableOnlyRequestUrl) {
        this.enableOnlyRequestUrl = enableOnlyRequestUrl;
    }

    public String getOnlyRequestUrl() {
        return onlyRequestUrl;
    }

    public void setOnlyRequestUrl(String onlyRequestUrl) {
        this.onlyRequestUrl = onlyRequestUrl;
    }
}