package cn.easyutil.easyapi.configuration;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix = "easyapi.sync")
public class EasyapiSyncRemoteConfiguration {

    public enum OverwriteType{
        /** 完全覆盖*/
        overwrite(0),
        /** 增量*/
        increment(1),
        /** 替换*/
        replace(2);

        public int type;
        OverwriteType(int type) {
            this.type = type;
        }
    }

    public enum SyncType{
        //推送到远程
        push,
        //从远程拉取到本地
        pull
    }

    /** 是否开启同步*/
    private boolean enable = false;

    /** 目标机器地址*/
    private String host;

    /** 账号*/
    private String account;

    /** 密码*/
    private String password;

    /** 项目名称*/
    private String projectName;

    /** 模块名称*/
    private String moduleName;

    /** 目标机器项目名称*/
    private String targetProjectName;

    /** 目标机器模块名称*/
    private String targetModuleName;

    /** 同步类型*/
    private OverwriteType overwriteType;

    /** 本地推送和远程拉取*/
    private SyncType syncType = SyncType.push;

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getModuleName() {
        return moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public OverwriteType getOverwriteType() {
        return overwriteType;
    }

    public void setOverwriteType(OverwriteType overwriteType) {
        this.overwriteType = overwriteType;
    }

    public boolean isEnable() {
        return enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public SyncType getSyncType() {
        return syncType;
    }

    public void setSyncType(SyncType syncType) {
        this.syncType = syncType;
    }

    public String getTargetProjectName() {
        return targetProjectName;
    }

    public void setTargetProjectName(String targetProjectName) {
        this.targetProjectName = targetProjectName;
    }

    public String getTargetModuleName() {
        return targetModuleName;
    }

    public void setTargetModuleName(String targetModuleName) {
        this.targetModuleName = targetModuleName;
    }
}
