package cn.easyutil.easyapi.configuration;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.io.File;

@Component
@ConfigurationProperties(prefix = "easyapi")
public class EasyapiConfiguration {

    /** 是否开启接口文档*/
    private boolean enable = false;

    /** 是否重新扫描接口文档 */
    private boolean rescan = true;

    /** 更新已存在的文档*/
    private boolean renewDoc = true;

    /** 删除接口文档信息，保留其他数据 */
    private boolean dropDoc = false;

    /** 删除全部用户相关的数据*/
    private boolean dropUsers = false;

    /** 删除公共配置*/
    private boolean dropGlobalSetting = false;

    /** 删除历史全部信息*/
    private boolean dropAll = false;

    /** 是否开启参数校验*/
    private boolean enableConditon = false;

    /** 项目标题 */
    private String title = System.getProperty("user.dir").substring(System.getProperty("user.dir").lastIndexOf(File.separator)+1);

    /** 项目描述*/
    private String description = "";

    /** 项目源码路径*/
    private String projectSourcePath;

    /** 扫描包名称*/
    private String scanPackage = "";

    /** 数组生成mock的长度*/
    private int mockArraySize = 12;

    public String getProjectSourcePath() {
        return projectSourcePath;
    }

    public void setProjectSourcePath(String projectSourcePath) {
        this.projectSourcePath = projectSourcePath;
    }

    public boolean isEnable() {
        return enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isRescan() {
        return rescan;
    }

    public void setRescan(boolean rescan) {
        this.rescan = rescan;
    }

    public boolean isDropDoc() {
        return dropDoc;
    }

    public void setDropDoc(boolean dropDoc) {
        this.dropDoc = dropDoc;
    }

    public boolean isDropAll() {
        return dropAll;
    }

    public boolean isDropUsers() {
        return dropUsers;
    }

    public void setDropUsers(boolean dropUsers) {
        this.dropUsers = dropUsers;
    }

    public boolean isDropGlobalSetting() {
        return dropGlobalSetting;
    }

    public void setDropGlobalSetting(boolean dropGlobalSetting) {
        this.dropGlobalSetting = dropGlobalSetting;
    }

    public boolean isRenewDoc() {
        return renewDoc;
    }

    public void setRenewDoc(boolean renewDoc) {
        this.renewDoc = renewDoc;
    }

    public void setDropAll(boolean dropAll) {
        this.dropAll = dropAll;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getScanPackage() {
        return scanPackage;
    }

    public void setScanPackage(String scanPackage) {
        this.scanPackage = scanPackage;
    }

    public boolean isEnableConditon() {
        return enableConditon;
    }

    public void setEnableConditon(boolean enableConditon) {
        this.enableConditon = enableConditon;
    }

    public int getMockArraySize() {
        return mockArraySize;
    }

    public void setMockArraySize(int mockArraySize) {
        this.mockArraySize = mockArraySize;
    }
}
