package cn.easyutil.easyapi.configuration;

import cn.easyutil.easyapi.EasyapiRun;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Import;

/**
 * 在没有配置文件的情况下，通过配置类去加载
 */
@Import(SpringRunEnvClassComponent.class)
@ConditionalOnMissingBean(EasyapiAotuConfiguration.class)
public abstract class AbstractConfigurationCreator implements ConfigurationCreator,ApplicationContextAware, InitializingBean {

    @Autowired
    private static ApplicationContext appContext;

    /**
     * 补充和完善配置
     * @param configuration 从spring上下文获取的配置
     * @return  补充完成后的配置
     */
    abstract public AllConfiguration replenish(AllConfiguration configuration);

    @Override
    public AllConfiguration getConfiguration() {
        AllConfiguration configuration = new AllConfiguration();
        configuration.setConfiguration(new EasyapiConfiguration());
        configuration.setSyncRemoteConfiguration(new EasyapiSyncRemoteConfiguration());
        configuration.setUserConfiguration(new EasyapiUserConfiguration());
        configuration.setFilterClassConfiguration(new EasyapiFilterConfiguration());
        configuration.setFilterBeanConfiguration(new EasyapiFilterBeanConfiguration());
        configuration.setDataConfiguration(new EasyapiDataConfiguration());
        configuration.setUnitConfiguration(new EasyapiUnitConfiguration());
        configuration = replenish(configuration);
        return configuration;
    }

    /**
     * 是否立刻开始生成接口文档
     * @return
     */
    protected boolean runNow(){
        return true;
    }

    @Override
    public void afterPropertiesSet(){
        if(runNow()){
            EasyapiRun.run(getConfiguration(),appContext);
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        appContext = applicationContext;
    }
}
