/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.parameterized;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenericTypeBind {
    private List<Map<String, Type>> binds = new ArrayList<Map<String, Type>>();
    private Set<String> keys = new HashSet<String>();

    public void bind(String typeName, Type type) {
        this.remove(typeName);
        HashMap<String, Type> map = new HashMap<String, Type>();
        map.put(typeName, type);
        this.binds.add(map);
        this.keys.add(typeName);
    }

    public void binds(GenericTypeBind binds) {
        if (binds == null || binds.size() == 0) {
            return;
        }
        for (String key : binds.keys()) {
            if (!this.keys.contains(key)) {
                this.bind(key, binds.get(key));
                continue;
            }
            Type valType = binds.get(key);
            Type val = this.get(key);
            if (!(val instanceof TypeVariable)) continue;
            this.bind(key, valType);
        }
    }

    public Type get(int index) {
        if (index >= this.binds.size()) {
            return null;
        }
        return this.binds.get(index).values().iterator().next();
    }

    public Type get(String typeName) {
        for (Map<String, Type> bind : this.binds) {
            if (!bind.containsKey(typeName)) continue;
            return bind.get(typeName);
        }
        return null;
    }

    public void remove(String typeName) {
        Iterator<Map<String, Type>> iterator = this.binds.iterator();
        while (iterator.hasNext()) {
            Map<String, Type> next = iterator.next();
            if (!next.containsKey(typeName)) continue;
            iterator.remove();
            this.keys.remove(typeName);
            return;
        }
    }

    public Type matchVariable(String typeName) {
        if (typeName == null) {
            return null;
        }
        Type type = this.get(typeName);
        if (type == null) {
            return null;
        }
        while (type instanceof TypeVariable && (type = this.get(type.getTypeName())) != null) {
        }
        return type;
    }

    public void remove(int index) {
        if (index > this.binds.size()) {
            return;
        }
        this.binds.remove(index);
    }

    public Set<String> keys() {
        return this.keys;
    }

    public int size() {
        return this.binds.size();
    }
}

