/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.ReadInterfaceApiFilter;
import cn.easyutil.easyapi.filter.model.DefaultReadInterfaceApi;
import cn.easyutil.easyapi.logic.creator.ApiCreator;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.reflect.Method;

public class InterfaceCreator
implements ApiCreator {
    private Method method;
    private DBModuleInterfaceEntity interfaceBean;
    private ReadInterfaceApiFilter filter = new DefaultReadInterfaceApi();
    private ApiExtra extra;

    private InterfaceCreator() {
    }

    public static InterfaceCreator builder(Method method) {
        InterfaceCreator creator = new InterfaceCreator();
        creator.method = method;
        return creator;
    }

    public InterfaceCreator setFilter(ReadInterfaceApiFilter filter) {
        if (filter == null) {
            return this;
        }
        this.filter = filter;
        return this;
    }

    public DBModuleInterfaceEntity buildInterface() {
        if (this.interfaceBean != null) {
            return this.interfaceBean;
        }
        try {
            this.create();
        }
        catch (Exception e) {
            System.out.println("\u521b\u5efa\u63a5\u53e3:" + this.method.toGenericString() + "\u5931\u8d25,\u539f\u56e0:" + e.getMessage());
            e.printStackTrace();
        }
        return this.interfaceBean;
    }

    private void create() {
        this.interfaceBean = new DBModuleInterfaceEntity();
        this.interfaceBean.setShowName(this.filter.showName(this.method, this.extra));
        if (StringUtil.isEmpty(this.interfaceBean.getShowName())) {
            this.interfaceBean.setShowName(this.extra.getMethodComment().getComment());
        }
        if (StringUtil.isEmpty(this.interfaceBean.getShowName())) {
            this.interfaceBean.setShowName(this.method.getName());
        }
        this.interfaceBean.setShowName(this.interfaceBean.getShowName().trim());
        this.interfaceBean.setMethodName(this.method.getName());
        this.interfaceBean.setDescription(this.filter.description(this.method, this.extra).trim());
        this.interfaceBean.setRequestMethod(this.filter.requestMethod(this.method, this.extra));
        this.interfaceBean.setBodyType(this.filter.bodyType(this.method, this.extra).getType());
        this.interfaceBean.setPinyin(StringUtil.toPinYin(this.interfaceBean.getShowName()).trim());
        this.interfaceBean.setSource(this.extra.getMethodComment().getSource());
        this.interfaceBean.setCreateTime(System.currentTimeMillis());
        this.interfaceBean.setUpdateTime(System.currentTimeMillis());
        this.interfaceBean.setUnique(this.filter.unique(this.method, this.extra));
    }

    @Override
    public InterfaceCreator setApiExtra(ApiExtra extra) {
        this.extra = extra;
        return this;
    }
}

