/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.ReadControllerApiFilter;
import cn.easyutil.easyapi.filter.model.DefaultReadControllerApi;
import cn.easyutil.easyapi.util.StringUtil;

public class ControllerCreator {
    private Class clazz;
    private DBModuleControllerEntity controllerBean;
    private ReadControllerApiFilter filter = new DefaultReadControllerApi();
    private ApiExtra extra;

    private ControllerCreator() {
    }

    public static ControllerCreator builder(Class clazz) {
        ControllerCreator creator = new ControllerCreator();
        creator.clazz = clazz;
        return creator;
    }

    public ControllerCreator setFilter(ReadControllerApiFilter filter) {
        if (filter == null) {
            return this;
        }
        this.filter = filter;
        return this;
    }

    public ControllerCreator setExtra(ApiExtra extra) {
        this.extra = extra;
        return this;
    }

    public DBModuleControllerEntity buildController() {
        if (this.controllerBean != null) {
            return this.controllerBean;
        }
        try {
            this.create();
        }
        catch (Exception e) {
            throw new ApidocException("\u521b\u5efacontroller:" + this.clazz.getCanonicalName() + "\u5931\u8d25,\u539f\u56e0:" + e.getMessage());
        }
        return this.controllerBean;
    }

    private void create() {
        this.controllerBean = new DBModuleControllerEntity();
        this.controllerBean.setShowName(this.filter.showName(this.clazz, this.extra));
        if (StringUtil.isEmpty(this.controllerBean.getShowName())) {
            this.controllerBean.setShowName(this.clazz.getSimpleName());
        }
        this.controllerBean.setShowName(this.controllerBean.getShowName().trim());
        this.controllerBean.setApiPath(this.filter.requestPath(this.clazz, this.extra));
        this.controllerBean.setClassName(this.clazz.getCanonicalName());
        this.controllerBean.setPinyin(StringUtil.toPinYin(this.controllerBean.getShowName()).trim());
        this.controllerBean.setDescription(this.filter.description(this.clazz, this.extra));
        this.controllerBean.setAuthor(this.filter.author(this.clazz, this.extra));
        this.controllerBean.setSource(this.extra.getControllerComment().getSource());
        this.controllerBean.setSearchTags(DBModuleControllerEntity.buildSearchTag(this.controllerBean).trim());
    }
}

