/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBArticleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBInterfaceParamEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHeaderEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHostEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleOutPackageEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleScriptEntity;
import cn.easyutil.easyapi.entity.db.doc.DBMouduleEnvEntity;
import cn.easyutil.easyapi.interview.dto.GetOutPackagesDto;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.dto.SearchDto;
import cn.easyutil.easyapi.interview.dto.SelectInterfacesDto;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.interview.vo.FindControllerAndInterfaceVo;
import cn.easyutil.easyapi.interview.vo.InterfaceInfoVo;
import cn.easyutil.easyapi.logic.condition.MockProcess2;
import cn.easyutil.easyapi.service.ArticleService;
import cn.easyutil.easyapi.service.ControllerService;
import cn.easyutil.easyapi.service.EnvService;
import cn.easyutil.easyapi.service.HeaderService;
import cn.easyutil.easyapi.service.HostService;
import cn.easyutil.easyapi.service.InterfaceParamService;
import cn.easyutil.easyapi.service.InterfaceService;
import cn.easyutil.easyapi.service.OutPackageService;
import cn.easyutil.easyapi.service.ScriptService;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnMissingBean(name={"easyapiSimpleApidocController"})
@RequestMapping(value={"/easyapi/doc/simple"})
public class SimpleApidocController {
    @Resource(name="easyapiControllerService")
    private ControllerService controllerService;
    @Resource(name="easyapiInterfaceService")
    private InterfaceService interfaceService;
    @Resource(name="easyapiInterfaceParamService")
    private InterfaceParamService interfaceParamService;
    @Resource(name="easyapiHostService")
    private HostService hostService;
    @Resource(name="easyapiEnvService")
    private EnvService envService;
    @Resource(name="easyapiHeaderService")
    private HeaderService headerService;
    @Resource(name="easyapiScriptService")
    private ScriptService scriptService;
    @Resource(name="easyapiArticleService")
    private ArticleService articleService;
    @Resource(name="easyapiOutPackageService")
    private OutPackageService outPackageService;

    @ApidocComment(value="\u83b7\u53d6\u63a5\u53e3\u63a7\u5236\u5668\u5217\u8868")
    @PostMapping(value={"/getControllers"})
    @AccessAuth(code=1000)
    public List<FindControllerAndInterfaceVo> getControllers(@RequestBody(required=false) SearchDto dto) {
        List inList;
        if (dto == null) {
            dto = new SearchDto();
        }
        Map<Object, Object> controllerAndInterfaceMap = new HashMap();
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        DBModuleControllerEntity entity = new DBModuleControllerEntity();
        entity.setModuleId(currentModuleId);
        List list = this.controllerService.list(EasyapiBindSQLExecuter.build(entity).setReturnParam(BaseDbEntity::getId).like(!StringUtil.isEmpty(dto), DBModuleControllerEntity::getSearchTags, dto.getSearch(), new Boolean[0]));
        if (list != null) {
            controllerAndInterfaceMap = list.stream().collect(Collectors.toMap(BaseDbEntity::getId, c -> new ArrayList()));
        }
        if ((inList = this.interfaceService.list(EasyapiBindSQLExecuter.build(new DBModuleInterfaceEntity()).setReturnParam(BaseDbEntity::getId, DBModuleInterfaceEntity::getControllerId).like(!StringUtil.isEmpty(dto), DBModuleInterfaceEntity::getSearchTags, dto.getSearch(), new Boolean[0]))) != null) {
            for (DBModuleInterfaceEntity inEntity : inList) {
                Long inId = inEntity.getId();
                Long controllerId = inEntity.getControllerId();
                controllerAndInterfaceMap.computeIfAbsent(controllerId, k -> new ArrayList());
                ((List)controllerAndInterfaceMap.get(controllerId)).add(inId);
            }
        }
        if (controllerAndInterfaceMap.isEmpty()) {
            return null;
        }
        ArrayList<FindControllerAndInterfaceVo> vos = new ArrayList<FindControllerAndInterfaceVo>();
        List controllers = this.controllerService.list(EasyapiBindSQLExecuter.build(new DBModuleControllerEntity()).in(BaseDbEntity::getId, controllerAndInterfaceMap.keySet(), new Boolean[0]).orderBy(DBModuleControllerEntity::getSort, true).orderBy(DBModuleControllerEntity::getPinyin, true));
        for (DBModuleControllerEntity controller : controllers) {
            FindControllerAndInterfaceVo vo = new FindControllerAndInterfaceVo();
            BeanUtils.copyProperties((Object)controller, (Object)vo);
            List inIds = (List)controllerAndInterfaceMap.get(controller.getId());
            if (inIds.isEmpty()) {
                vos.add(vo);
                continue;
            }
            List children = this.interfaceService.list(EasyapiBindSQLExecuter.build(new DBModuleInterfaceEntity()).in(BaseDbEntity::getId, (Collection)inIds, new Boolean[0]).orderBy(DBModuleControllerEntity::getSort, true).orderBy(DBModuleControllerEntity::getPinyin, true));
            vo.setChildren(Optional.ofNullable(children).orElse(Collections.emptyList()));
            vos.add(vo);
        }
        return vos;
    }

    @ApidocComment(value="\u4fee\u6539\u63a7\u5236\u5668\u4fe1\u606f")
    @PostMapping(value={"/updateControllerInfo"})
    @AccessAuth(code=1000)
    public void updateControllerInfo(@RequestBody DBModuleControllerEntity entity) {
        AssertUtil.isNull((Object)entity.getId(), "\u63a7\u5236\u5668id\u4e0d\u80fd\u4e3a\u7a7a");
        this.controllerService.update(entity);
        DBModuleControllerEntity query = (DBModuleControllerEntity)this.controllerService.getById(entity.getId());
        query.setSearchTags(DBModuleControllerEntity.buildSearchTag(query));
        this.controllerService.update(query);
    }

    @ApidocComment(value="\u5220\u9664\u63a7\u5236\u5668\u4fe1\u606f")
    @PostMapping(value={"/delController"})
    @AccessAuth(code=1000)
    public void delController(@RequestBody IdDto dto) {
        this.controllerService.deleteById(dto.getId());
    }

    @ApidocComment(value="\u67e5\u8be2\u63a5\u53e3\u5217\u8868")
    @PostMapping(value={"/selectInterfaces"})
    @AccessAuth(code=1000)
    public List<DBModuleInterfaceEntity> selectInterfaces(@RequestBody(required=false) SelectInterfacesDto dto) {
        DBModuleInterfaceEntity entity = new DBModuleInterfaceEntity();
        entity.setModuleId(CurrentSession.getCurrentModuleId());
        List<DBModuleInterfaceEntity> list = this.interfaceService.list(EasyapiBindSQLExecuter.build(entity).like(!StringUtil.isEmpty(dto.getSearch()), DBModuleInterfaceEntity::getSearchTags, dto.getSearch(), new Boolean[0]).eq(dto.getControllerId() != null, DBModuleInterfaceEntity::getControllerId, dto.getControllerId(), new Boolean[0]).orderBy(DBModuleInterfaceEntity::getSort, true).orderBy(DBModuleInterfaceEntity::getPinyin, true));
        return list;
    }

    @ApidocComment(value="\u4fee\u6539\u63a5\u53e3\u4fe1\u606f")
    @PostMapping(value={"/updateInterfaces"})
    @AccessAuth(code=1000)
    public void updateInterfaces(@RequestBody InterfaceInfoVo vo) {
        if (vo.getInfo() != null) {
            AssertUtil.isNull((Object)vo.getInfo().getId(), "\u63a5\u53e3id\u4e0d\u80fd\u4e3a\u7a7a");
            this.interfaceService.update(vo.getInfo());
            DBModuleInterfaceEntity query = (DBModuleInterfaceEntity)this.interfaceService.getById(vo.getInfo().getId());
            query.setSearchTags(DBModuleInterfaceEntity.buildSearchTag(query));
            this.interfaceService.update(query);
        }
        if (vo.getParams() != null) {
            AssertUtil.isNull((Object)vo.getParams().getId(), "\u63a5\u53e3\u8be6\u60c5id\u4e0d\u80fd\u4e3a\u7a7a");
            DBInterfaceParamEntity entity = vo.getParams();
            this.interfaceParamService.update(entity);
        }
    }

    @ApidocComment(value="\u6839\u636e\u63a5\u53e3id\u83b7\u53d6\u63a5\u53e3\u8be6\u60c5\u4fe1\u606f")
    @PostMapping(value={"/interfaceInfo"})
    @AccessAuth(code=1000)
    public InterfaceInfoVo interfaceInfo(@RequestBody IdDto dto) {
        Object mock;
        List<DocParamEntity> mockParams;
        DBModuleInterfaceEntity info = (DBModuleInterfaceEntity)this.interfaceService.getById(dto.getId());
        AssertUtil.isNull((Object)info, "\u63a5\u53e3\u4e0d\u5b58\u5728");
        DBInterfaceParamEntity query = new DBInterfaceParamEntity();
        query.setInterfaceId(info.getId());
        DBInterfaceParamEntity params = this.interfaceParamService.get(query);
        String requestParamJson = params.getRequestParamJson();
        String responseParamJson = params.getResponseParamJson();
        MockProcess2 mocker = MockProcess2.with(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadMockTemplateFilter());
        if (!StringUtil.isEmpty(requestParamJson)) {
            mockParams = JsonUtil.jsonToList(requestParamJson, DocParamEntity.class);
            mock = mocker.mockByApiParams(mockParams);
            params.setRequestMock(JsonUtil.beanToJson(mock));
            params.setRequestParamJson(JsonUtil.beanToJson(mockParams));
        }
        if (!StringUtil.isEmpty(responseParamJson)) {
            mockParams = JsonUtil.jsonToList(responseParamJson, DocParamEntity.class);
            mock = mocker.mockByApiParams(mockParams);
            params.setResponseMock(JsonUtil.beanToJson(mock));
            params.setResponseParamJson(JsonUtil.beanToJson(mockParams));
        }
        InterfaceInfoVo vo = new InterfaceInfoVo();
        vo.setInfo(info);
        vo.setParams(params);
        return vo;
    }

    @ApidocComment(value="\u5220\u9664\u63a5\u53e3\u4fe1\u606f")
    @PostMapping(value={"/delInterfaces"})
    @AccessAuth(code=1000)
    public void delInterfaces(@RequestBody IdDto dto) {
        this.interfaceService.deleteById(dto.getId());
    }

    @ApidocComment(value="\u83b7\u53d6\u811a\u672c\u5217\u8868")
    @PostMapping(value={"/getScripts"})
    @AccessAuth(code=1000)
    public List<DBModuleScriptEntity> getScripts() {
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        Long userId = CurrentSession.getCurrentUser().getId();
        return this.scriptService.list(EasyapiBindSQLExecuter.build(new DBModuleScriptEntity()).eq(DBModuleScriptEntity::getModuleId, (Object)currentModuleId, new Boolean[0]).eq(DBModuleScriptEntity::getUserId, (Object)userId, new Boolean[0]).orderBy(DBModuleScriptEntity::getSort));
    }

    @ApidocComment(value="\u6dfb\u52a0\u5168\u5c40\u811a\u672c")
    @PostMapping(value={"/addScript"})
    @AccessAuth(code=1000)
    public void addScript(@RequestBody DBModuleScriptEntity entity) {
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        Long userId = CurrentSession.getCurrentUser().getId();
        entity.setModuleId(currentModuleId);
        entity.setUserId(userId);
        this.scriptService.insert(entity);
    }

    @ApidocComment(value="\u4fee\u6539\u5168\u5c40\u811a\u672c")
    @PostMapping(value={"/updateScript"})
    @AccessAuth(code=1000)
    public void updateScript(@RequestBody DBModuleScriptEntity entity) {
        this.scriptService.update(entity);
    }

    @ApidocComment(value="\u5220\u9664\u5168\u5c40\u811a\u672c")
    @PostMapping(value={"/delScript"})
    @AccessAuth(code=1000)
    public void delScript(@RequestBody IdDto dto) {
        this.scriptService.deleteById(dto.getId());
    }

    @ApidocComment(value="\u83b7\u53d6\u6587\u7ae0\u5217\u8868")
    @PostMapping(value={"/getArticles"})
    @AccessAuth(code=1000)
    public List<DBArticleEntity> getArticles() {
        return this.articleService.list(new DBArticleEntity());
    }

    @ApidocComment(value="\u83b7\u53d6\u8bf7\u6c42\u73af\u5883\u5217\u8868")
    @PostMapping(value={"/getHosts"})
    @AccessAuth(code=1000)
    public List<DBModuleHostEntity> getHosts() {
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        DBModuleHostEntity entity = new DBModuleHostEntity();
        entity.setModuleId(currentModuleId);
        List<DBModuleHostEntity> list = this.hostService.list(entity);
        list.sort(Comparator.comparing(DBModuleHostEntity::getCanDelete));
        return list;
    }

    @ApidocComment(value="\u6dfb\u52a0\u8bf7\u6c42\u73af\u5883")
    @PostMapping(value={"/addHost"})
    @AccessAuth(code=1000)
    public void addHost(@RequestBody DBModuleHostEntity hostEntity) {
        this.hostService.insert(hostEntity);
    }

    @ApidocComment(value="\u4fee\u6539\u8bf7\u6c42\u73af\u5883")
    @PostMapping(value={"/updateHost"})
    @AccessAuth(code=1000)
    public void updateHost(@RequestBody DBModuleHostEntity hostEntity) {
        AssertUtil.isNull((Object)hostEntity.getId(), "\u73af\u5883id\u4e0d\u80fd\u4e3a\u7a7a");
        this.hostService.update(hostEntity);
    }

    @ApidocComment(value="\u5220\u9664\u8bf7\u6c42\u73af\u5883")
    @PostMapping(value={"/delHost"})
    @AccessAuth(code=1000)
    public void delHost(@RequestBody IdDto dto) {
        this.hostService.deleteById(dto.getId());
    }

    @ApidocComment(value="\u83b7\u53d6\u5168\u90e8\u73af\u5883\u53d8\u91cf")
    @PostMapping(value={"/getEnvsgs"})
    @AccessAuth(code=1000)
    public List<DBMouduleEnvEntity> getEnvsgs() {
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        DBMouduleEnvEntity entity = new DBMouduleEnvEntity();
        entity.setModuleId(currentModuleId);
        entity.setUserId(CurrentSession.getCurrentUser().getId());
        List<DBMouduleEnvEntity> list = this.envService.list(entity);
        return list;
    }

    @ApidocComment(value="\u6dfb\u52a0\u73af\u5883\u53d8\u91cf")
    @PostMapping(value={"/addEnv"})
    @AccessAuth(code=1000)
    public void addEnv(@RequestBody DBMouduleEnvEntity env) {
        env.setUserId(CurrentSession.getCurrentUser().getId());
        DBMouduleEnvEntity query = new DBMouduleEnvEntity();
        query.setUserId(CurrentSession.getCurrentUser().getId());
        query.setModuleId(CurrentSession.getCurrentModuleId());
        query.setKey(env.getKey());
        query = this.envService.get(query);
        if (query != null) {
            this.envService.deleteById(query.getId());
        }
        this.envService.insert(env);
    }

    @ApidocComment(value="\u4fee\u6539\u73af\u5883\u53d8\u91cf")
    @PostMapping(value={"/updateEnv"})
    @AccessAuth(code=1000)
    public void updateEnv(@RequestBody DBMouduleEnvEntity env) {
        AssertUtil.isNull((Object)env.getId(), "\u73af\u5883\u53d8\u91cfid\u4e0d\u80fd\u4e3a\u7a7a");
        DBMouduleEnvEntity query = new DBMouduleEnvEntity();
        query.setUserId(CurrentSession.getCurrentUser().getId());
        query.setModuleId(CurrentSession.getCurrentModuleId());
        query.setKey(env.getKey());
        query = this.envService.get(query);
        if (query != null && !query.getId().equals(env.getId())) {
            this.envService.deleteById(query.getId());
        }
        this.envService.update(env);
    }

    @ApidocComment(value="\u5220\u9664\u73af\u5883\u53d8\u91cf")
    @PostMapping(value={"/delEnv"})
    @AccessAuth(code=1000)
    public void delEnv(@RequestBody IdDto dto) {
        this.envService.deleteById(dto.getId());
    }

    @ApidocComment(value="\u83b7\u53d6\u53c2\u6570\u7684\u5916\u5305\u88c5\u5217\u8868")
    @PostMapping(value={"/getOutPackages"})
    @AccessAuth(code=1000)
    public List<DBModuleOutPackageEntity> getOutPackages(@RequestBody GetOutPackagesDto dto) {
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        DBModuleOutPackageEntity entity = new DBModuleOutPackageEntity();
        entity.setModuleId(currentModuleId);
        entity.setType(dto.getType());
        List<DBModuleOutPackageEntity> list = this.outPackageService.list(entity);
        return list;
    }

    @ApidocComment(value="\u65b0\u589e\u53c2\u6570\u7684\u5916\u5305\u88c5")
    @PostMapping(value={"/addOutPackages"})
    @AccessAuth(code=1000)
    public void addOutPackages(@RequestBody DBModuleOutPackageEntity entity) {
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        entity.setModuleId(currentModuleId);
        if (entity.getDefaultStatus() == 1) {
            DBModuleOutPackageEntity query = new DBModuleOutPackageEntity();
            query.setModuleId(currentModuleId);
            query.setDefaultStatus(entity.getDefaultStatus());
            query.setType(entity.getType());
            query = this.outPackageService.get(query);
            AssertUtil.isTrue(query != null, "\u5916\u5305\u88c5\u53ea\u5141\u8bb8\u6709\u4e00\u4e2a\u5305\u88c5\u503c");
        }
        String key = entity.getKey();
        DBModuleOutPackageEntity find = new DBModuleOutPackageEntity();
        find.setKey(key);
        find.setType(entity.getType());
        find = this.outPackageService.get(find);
        if (find != null) {
            this.outPackageService.deleteById(find.getId());
        }
        this.outPackageService.insert(entity);
    }

    @ApidocComment(value="\u4fee\u6539\u53c2\u6570\u7684\u5916\u5305\u88c5")
    @PostMapping(value={"/updateOutPackages"})
    @AccessAuth(code=1000)
    public void updateOutPackages(@RequestBody DBModuleOutPackageEntity entity) {
        DBModuleOutPackageEntity find;
        AssertUtil.isNull((Object)entity.getId(), "\u5916\u5305\u88c5id\u4e0d\u80fd\u4e3a\u7a7a");
        DBModuleOutPackageEntity query = (DBModuleOutPackageEntity)this.outPackageService.getById(entity.getId());
        if (entity.getDefaultStatus() != null && entity.getDefaultStatus() == 1 && !entity.getDefaultStatus().equals(query.getDefaultStatus())) {
            Long currentModuleId = CurrentSession.getCurrentModuleId();
            find = new DBModuleOutPackageEntity();
            find.setModuleId(currentModuleId);
            find.setDefaultStatus(entity.getDefaultStatus());
            find.setType(entity.getType());
            find = this.outPackageService.get(query);
            AssertUtil.isTrue(find != null, "\u5916\u5305\u88c5\u53ea\u5141\u8bb8\u6709\u4e00\u4e2a\u5305\u88c5\u503c");
        }
        String key = entity.getKey();
        find = new DBModuleOutPackageEntity();
        find.setKey(key);
        find.setType(entity.getType());
        find = this.outPackageService.get(find);
        if (find != null && !find.getId().equals(entity.getId())) {
            this.outPackageService.deleteById(find.getId());
        }
        this.outPackageService.update(entity);
    }

    @ApidocComment(value="\u5220\u9664\u53c2\u6570\u7684\u5916\u5305\u88c5")
    @PostMapping(value={"/delOutPackages"})
    @AccessAuth(code=1000)
    public void delOutPackages(@RequestBody IdDto dto) {
        this.outPackageService.deleteById(dto.getId());
    }

    @ApidocComment(value="\u6a21\u62df\u8bf7\u6c42")
    @PostMapping(value={"/mock"})
    @AccessAuth(code=1000)
    public Object mock(String path) {
        DBModuleInterfaceEntity interfaceEntity = new DBModuleInterfaceEntity();
        interfaceEntity.setRequestUrl(path);
        interfaceEntity = this.interfaceService.get(interfaceEntity);
        AssertUtil.isNull((Object)interfaceEntity, "\u672a\u77e5\u63a5\u53e3");
        DBInterfaceParamEntity entity = new DBInterfaceParamEntity();
        entity.setInterfaceId(interfaceEntity.getId());
        entity = this.interfaceParamService.get(entity);
        AssertUtil.isNull((Object)entity, "\u672a\u77e5\u63a5\u53e3");
        return JSON.parse((String)entity.getResponseMock());
    }

    @ApidocComment(value="\u83b7\u53d6\u5168\u5c40header")
    @PostMapping(value={"/getHeaders"})
    @AccessAuth(code=1000)
    public List<DBModuleHeaderEntity> getHeaders() {
        DBModuleHeaderEntity entity = new DBModuleHeaderEntity();
        entity.setUserId(CurrentSession.getCurrentUser().getId());
        entity.setModuleId(CurrentSession.getCurrentModuleId());
        return this.headerService.list(entity);
    }

    @ApidocComment(value="\u6dfb\u52a0header")
    @PostMapping(value={"/addHeader"})
    @AccessAuth(code=1000)
    public void addHeader(@RequestBody DBModuleHeaderEntity entity) {
        entity.setUserId(CurrentSession.getCurrentUser().getId());
        entity.setModuleId(CurrentSession.getCurrentModuleId());
        AssertUtil.isEmpty(entity.getKey(), "key\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isEmpty(entity.getVal(), "val\u4e0d\u80fd\u4e3a\u7a7a");
        DBModuleHeaderEntity query = new DBModuleHeaderEntity();
        query.setUserId(CurrentSession.getCurrentUser().getId());
        query.setModuleId(CurrentSession.getCurrentModuleId());
        query.setKey(entity.getKey());
        query = this.headerService.get(query);
        if (query != null) {
            this.headerService.deleteById(query.getId());
        }
        this.headerService.insert(entity);
    }

    @ApidocComment(value="\u5220\u9664header")
    @PostMapping(value={"/delHeader"})
    @AccessAuth(code=1000)
    public void delHeader(@RequestBody IdDto dto) {
        this.headerService.deleteById(dto.getId());
    }

    @ApidocComment(value="\u4fee\u6539header")
    @PostMapping(value={"/updateHeader"})
    @AccessAuth(code=1000)
    public void updateHeader(@RequestBody DBModuleHeaderEntity entity) {
        AssertUtil.isNull((Object)entity.getId(), "id\u4e0d\u80fd\u4e3a\u7a7a");
        DBModuleHeaderEntity query = new DBModuleHeaderEntity();
        query.setUserId(CurrentSession.getCurrentUser().getId());
        query.setModuleId(CurrentSession.getCurrentModuleId());
        query.setKey(entity.getKey());
        query = this.headerService.get(query);
        if (query != null && !query.getId().equals(entity.getId())) {
            this.headerService.deleteById(query.getId());
        }
        this.headerService.update(entity);
    }
}

