/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.configuration;

import cn.easyutil.easyapi.EasyapiRun;
import cn.easyutil.easyapi.configuration.AllConfiguration;
import cn.easyutil.easyapi.configuration.ConfigurationCreator;
import cn.easyutil.easyapi.configuration.EasyapiAotuConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiDataConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiFilterBeanConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiFilterConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiSyncRemoteConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiUnitConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiUserConfiguration;
import cn.easyutil.easyapi.configuration.SpringRunEnvClassComponent;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Import;

@Import(value={SpringRunEnvClassComponent.class})
@ConditionalOnMissingBean(value={EasyapiAotuConfiguration.class})
public abstract class AbstractConfigurationCreator
implements ConfigurationCreator,
ApplicationContextAware,
InitializingBean {
    @Autowired
    private static ApplicationContext appContext;

    public abstract AllConfiguration replenish(AllConfiguration var1);

    @Override
    public AllConfiguration getConfiguration() {
        AllConfiguration configuration = new AllConfiguration();
        configuration.setConfiguration(new EasyapiConfiguration());
        configuration.setSyncRemoteConfiguration(new EasyapiSyncRemoteConfiguration());
        configuration.setUserConfiguration(new EasyapiUserConfiguration());
        configuration.setFilterClassConfiguration(new EasyapiFilterConfiguration());
        configuration.setFilterBeanConfiguration(new EasyapiFilterBeanConfiguration());
        configuration.setDataConfiguration(new EasyapiDataConfiguration());
        configuration.setUnitConfiguration(new EasyapiUnitConfiguration());
        configuration = this.replenish(configuration);
        return configuration;
    }

    protected boolean runNow() {
        return true;
    }

    public void afterPropertiesSet() {
        if (this.runNow()) {
            EasyapiRun.run(this.getConfiguration(), appContext);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        appContext = applicationContext;
    }
}

