package cn.easyutil.easyapi.service;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.datasource.EasyapiBindSqlExecution;
import cn.easyutil.easyapi.datasource.bean.EasyApiBindSqlResult;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindPage;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.util.ObjectUtil;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class DBService<T extends BaseDbEntity> {

    public void insert(T t){
        t.setId(null);
        t.setCreateTime(System.currentTimeMillis());
        t.setUpdateTime(System.currentTimeMillis());
        getExecution().insert(t);
    }

    public void insertAny(Collection<T> collection){
        getExecution().insert(collection);
    }


    public T getById(Long id){
        try {
            T t = (T) ObjectUtil.getGeneric(this.getClass()).newInstance();
            t.setId(id);
            return get(t);
        } catch (Exception e) {
            throw new ApidocException(e);
        }
    }

    public T get(T t){
        return get(EasyapiBindSQLExecuter.build(t));
    }

    public T get(EasyapiBindSQLExecuter executer){
        return getExecution().selectOne(executer.eq(BaseDbEntity::getDeleted, 0));
    }

    public List<T> list(T t){
        return list(EasyapiBindSQLExecuter.build(t));
    }

    public List<T> list(EasyapiBindSQLExecuter executer){
        return getExecution().select(executer.eq(BaseDbEntity::getDeleted, 0).orderBy(BaseDbEntity::getCreateTime, false));
    }

    public void update(T t){
        t.setUpdateTime(System.currentTimeMillis());
        getExecution().update(t);
    }

    public void update(EasyapiBindSQLExecuter executer){
        getExecution().update(executer);
    }

    public void deleteById(Long id){
        try {
            T t = (T) ObjectUtil.getGeneric(this.getClass()).newInstance();
            t.setId(id);
            delete(t);
        } catch (Exception e) {
            throw new ApidocException(e);
        }
    }

    public void delete(T t){
        getExecution().delete(t);
    }

    public void delete(EasyapiBindSQLExecuter executer){
        getExecution().delete(executer);
    }

    public EasyApiBindSqlResult page(T t,Integer current, Integer showCount){
        return page(EasyapiBindSQLExecuter.build(t),current,showCount);
    }

    public EasyApiBindSqlResult page(EasyapiBindSQLExecuter executer,Integer current, Integer showCount){
        if(current == null){
            current = 1;
        }
        if(showCount == null){
            showCount = 5;
        }
        if(current < 0){
            EasyApiBindSqlResult result = new EasyApiBindSqlResult();
            List<T> list = list(executer);
            result.setResultList(list);
            EasyapiBindPage page = new EasyapiBindPage();
            page.setShowCount(showCount);
            page.setTotalResult(Optional.ofNullable(list).orElse(new ArrayList<>()).size());
            result.setPage(page);
            return result;
        }
        return getExecution().listPage(executer.eq(BaseDbEntity::getDeleted, 0).orderBy(BaseDbEntity::getCreateTime, false),current,showCount);
    }

    protected EasyapiBindSqlExecution getExecution(){
        return ProjectContext.execution;
    }
}
