package cn.easyutil.easyapi.logic.run;

import cn.easyutil.easyapi.configuration.*;
import cn.easyutil.easyapi.content.DBTableClassify;
import cn.easyutil.easyapi.content.DBTables;
import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.datasource.EasyapiBindSqlExecution;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.auth.AuthMoudle;
import cn.easyutil.easyapi.entity.db.auth.*;
import cn.easyutil.easyapi.entity.db.doc.DBArticleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHostEntity;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import cn.easyutil.easyapi.util.http.*;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.context.ApplicationContext;

import javax.sql.DataSource;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class DocCreatePre {

    /**
     * 项目配置文件
     */

    private AllConfiguration all;

    private ApplicationContext appContext;

    private EasyapiBindSqlExecution execution;

    public static DocCreatePre build(AllConfiguration all, ApplicationContext appContext){
        DocCreatePre pre = new DocCreatePre();
        pre.all = all;
        pre.appContext = appContext;
        return pre;
    }

    /**
     * 初始化
     */
    public void pre() {
        initBase();
        initDataSource();
        showLogo();
        initProject();
        getRomoteBannerAndDoc();

    }

    private void getRomoteBannerAndDoc(){
        //从远程获取文档介绍以及广告图
        HttpOperation operation = HttpUtilFactory.create(HttpImplEnum.httpClient);
        HttpReq httpReq = operation.getHttpReq();
        httpReq.setUrl("http://open.api.easyutil.cn/open/getBanner");
        httpReq.setMethod(HttpMethod.GET);
        //超时时间3秒
        httpReq.setConnectTimeOut(3*1000);
        try {
            HttpRes res = operation.doUrl();
            if(res.getResponseCode() == 200){
                String banner = JSONObject.parseObject(res.getResponseMsg()).getJSONObject("data").getString("banner");
                DBProjectEntity project = new DBProjectEntity();
                project.setDefaultStatus(1);
                project = execution.selectOne(project);
                project.setIndexBanner(banner);
                execution.update(project);
            }
        }catch (Exception e) {
            e.printStackTrace();
        }

        //获取文档列表
        httpReq.setUrl("http://open.api.easyutil.cn/open/getArticles");
        execution.delete(EasyapiBindSQLExecuter.build(new DBArticleEntity()).gte(DBArticleEntity::getId,0));
        try {
            HttpRes httpRes = operation.doUrl();
            if(httpRes.getResponseCode() == 200){
                JSONArray array = JSONObject.parseObject(httpRes.getResponseMsg()).getJSONArray("data");
                List<DBArticleEntity> articles = JsonUtil.jsonToList(array.toJSONString(), DBArticleEntity.class);
                if(articles==null || articles.isEmpty()){
                    addDefaultArticles();
                }else{
                    execution.insert(articles);
                }
            }
        }catch (Exception e) {
            //添加默认文章
            addDefaultArticles();
        }
    }

    private void addDefaultArticles(){
        List<DBArticleEntity> articles = new ArrayList<>();
        DBArticleEntity a1 = new DBArticleEntity();
        a1.setTitle("欢迎使用easyapi");
        a1.setContent("小明，起来致欢迎辞");
        articles.add(a1);

        DBArticleEntity a2 = new DBArticleEntity();
        a2.setTitle("如何使用自定义变量");
        a2.setContent("在任意输入框中填写 {{变量名}} 即可");
        articles.add(a2);

        DBArticleEntity a3 = new DBArticleEntity();
        a3.setTitle("如何切换请求环境");
        a3.setContent("在顶部设置里面有请求环境设置，可以增删环境，同时在接口模拟请求页面选择环境");
        articles.add(a3);

        execution.insert(articles);
    }

    private void initProject(){
        DBProjectEntity project = new DBProjectEntity();
        project.setDefaultStatus(1);
        project = execution.selectOne(project);
        DBModuleEntity module = execution.selectOne(EasyapiBindSQLExecuter.build(new DBModuleEntity()).eq(DBModuleEntity::getDefaultStatus, 1));
        if(project == null){
            project = addDefaultProject();
        }
        if(module == null){
            module = addDefaultModule(project);
        }
        DBUserEntity admin = execution.selectOne(EasyapiBindSQLExecuter.build(new DBUserEntity()).eq(DBUserEntity::getAccount, "admin"));
        if(admin == null){
            addDefaultUsers(module);
        }
        //创建默认的角色
        DBRoleEntity defaultRole = execution.selectOne(EasyapiBindSQLExecuter.build(new DBRoleEntity()).eq(DBRoleEntity::getDefaultRole, 1));
        if(defaultRole == null){
            defaultRole = new DBRoleEntity();
            defaultRole.setDefaultRole(1);
            defaultRole.setSuperAdminStatus(0);
            defaultRole.setRoleName("默认角色");
            execution.insert(defaultRole);
        }
        ProjectContext.currentProjectId = project.getId();
        ProjectContext.currentModuleId = module.getId();
        ProjectContext.currentProjectName = project.getName();
        ProjectContext.currentModuleName = module.getName();
    }

    private <T> T newInstance(Class<T> clazz){
        try {
            return clazz.newInstance();
        } catch (Exception e) {
            throw new ApidocException(e);
        }
    }

    private void initDataSource(){
        EasyapiConfiguration configuration = all.getConfiguration();
        EasyapiDataConfiguration dataConfiguration = all.getDataConfiguration();
        ProjectContext.execution = new EasyapiBindSqlExecution();
        this.execution = ProjectContext.execution;
        //处理数据库
        if(StringUtil.isEmpty(dataConfiguration.getDriverClassName())){
            dataConfiguration.setDriverClassName("org.h2.Driver");
        }
        if(StringUtil.isEmpty(dataConfiguration.getUrl())){
            dataConfiguration.setUrl("jdbc:h2:file:"+ProjectContext.dbPath+ProjectContext.dbFileName+"-"+configuration.getTitle());
        }
        if(StringUtil.isEmpty(dataConfiguration.getUserName())){
            dataConfiguration.setUserName("easyapi");
        }
        if(StringUtil.isEmpty(dataConfiguration.getPassword())){
            dataConfiguration.setPassword("123456");
        }

        if(dataConfiguration.getDataSource() != null){
            //使用用户提供的连接池
            ProjectContext.execution.setDataSource(dataConfiguration.getDataSource());
        }else{
            //创建连接池
            DataSource dataSource = dataSource(dataConfiguration.getUrl()
                    , dataConfiguration.getDriverClassName()
                    , dataConfiguration.getUserName()
                    , dataConfiguration.getPassword());
            ProjectContext.execution.setDataSource(dataSource);
        }
        //如果配置了删除构建，则删除相关表
        if(configuration.isDropAll()){
            for (DBTables table : DBTables.values()) {
                ProjectContext.execution.update(table.dropSql());
            }
        }
        //重新初始化数据库表，如果不存在则创建
        for (DBTables table : DBTables.values()) {
            ProjectContext.execution.update(table.createSql());
        }
        if(configuration.isDropUsers()){
            for (DBTables table : DBTables.getByClassify(DBTableClassify.user)) {
                ProjectContext.execution.update(table.clearSql());
            }
        }
        if(configuration.isDropGlobalSetting()){
            for (DBTables table : DBTables.getByClassify(DBTableClassify.global)) {
                ProjectContext.execution.update(table.clearSql());
            }
        }
        if(configuration.isDropDoc()){
            for (DBTables table : DBTables.getByClassify(DBTableClassify.doc)) {
                ProjectContext.execution.update(table.clearSql());
            }
        }
    }

    private static DataSource dataSource(String url,String driverClassName,String username, String password){
        // 连接数据库
//        String URL = "jdbc:h2:file:"+ProjectContext.dbPath+ProjectContext.dbFileName+"-"+projectName;
//        String USER = "easyapi";
//        String PASSWORD = "123456";

        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setUrl(url);
        druidDataSource.setUsername(username);
        druidDataSource.setPassword(password);
        druidDataSource.setDriverClassName(driverClassName);
        druidDataSource.setInitialSize(0);
        druidDataSource.setMaxActive(100);
        druidDataSource.setMaxWait(10000);
        druidDataSource.setMinIdle(20);
        druidDataSource.setValidationQuery("Select  'x' from DUAL");
        druidDataSource.setTestOnBorrow(false);
        druidDataSource.setTestOnReturn(false);
        druidDataSource.setTestWhileIdle(true);
        druidDataSource.setTimeBetweenEvictionRunsMillis(60000);
        druidDataSource.setMinEvictableIdleTimeMillis(25200000);
        druidDataSource.setRemoveAbandoned(true);
        druidDataSource.setRemoveAbandonedTimeout(1800);
        druidDataSource.setLogAbandoned(true);
        return druidDataSource;
    }

    private void initBase(){
        EasyapiFilterBeanConfiguration beans = all.getFilterBeanConfiguration();
        EasyapiFilterConfiguration classes = all.getFilterClassConfiguration();
        if(beans == null){
            beans = new EasyapiFilterBeanConfiguration();
            all.setFilterBeanConfiguration(beans);
        }
        if(beans.getReadControllerApiFilter() == null){
            beans.setReadControllerApiFilter(newInstance(classes.getReadControllerApiFilter()));
        }
        if(beans.getReadBeanApiFilter() == null){
            beans.setReadBeanApiFilter(newInstance(classes.getReadBeanApiFilter()));
        }
        if(beans.getReadInterfaceApiFilter() == null){
            beans.setReadInterfaceApiFilter(newInstance(classes.getReadInterfaceApiFilter()));
        }
        if(beans.getReadRequestParamApiFilter() == null){
            beans.setReadRequestParamApiFilter(newInstance(classes.getReadRequestParamApiFilter()));
        }
        if(beans.getReadResponseParamApiFilter() == null){
            beans.setReadResponseParamApiFilter(newInstance(classes.getReadResponseParamApiFilter()));
        }
        if(beans.getReadMockTemplateFilter() == null){
            beans.setReadMockTemplateFilter(newInstance(classes.getReadMockTemplateFilter()));
        }

        ProjectContext.allConfiguration = all;
        String projectSourcePath = all.getConfiguration().getProjectSourcePath();
        if(StringUtil.isEmpty(projectSourcePath)){
            try {
                projectSourcePath = new File("").getCanonicalPath();
            } catch (IOException e) {
                throw new ApidocException(e);
            }
        }
        ProjectContext.projectBasePath = projectSourcePath + File.separator + "src" + File.separator + "main" + File.separator + "java"
                + File.separator;
        if(!new File(projectSourcePath).exists()){
            throw new ApidocException("项目路径："+projectSourcePath+"错误");
        }
        //------初始化拦截器
//        EasyapiFilterConfiguration filterConfiguration = all.getFilterClassConfiguration();
//        if(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadMockTemplateFilter() instanceof DefaultReadMockTemplate){
//            DefaultReadMockTemplate template = (DefaultReadMockTemplate) ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadMockTemplateFilter();
//            template.setElExpression(ElExpression.with(DefaultSpelMethodParser.get()));
//        }
    }

    /**
     * 展示logo
     */
    private void showLogo() {
        String text = "                                        _\n" +
                "                                       (_)\n" +
                "  ___  __ _ ___ _   _ ______ __ _ _ __  _\n" +
                " / _ \\/ _` / __| | | |______/ _` | '_ \\| |\n" +
                "|  __/ (_| \\__ \\ |_| |     | (_| | |_) | |\n" +
                " \\___|\\__,_|___/\\__, |      \\__,_| .__/|_|\n" +
                "                 __/ |           | |\n" +
                "                |___/            |_|\n" +
                "    -------------------------------接口文档\n" +
                "    ---http://localhost:项目端口/apidoc.html";
        System.out.println(text);
    }

    /**
     * 初始化项目
     */
    private DBModuleEntity addDefaultModule(DBProjectEntity project){
        //初始化项目模块
        DBModuleEntity module = new DBModuleEntity();
        module.setProjectId(project.getId());
        module.setName("默认模块");
        module.setDescription("初始化项目模块");
        module.setOutPackgeStatus(0);
        module.setDefaultStatus(1);
        execution.insert(module);

        //初始化项目请求环境
        DBModuleHostEntity mock = new DBModuleHostEntity();
        mock.setModuleId(module.getId());
        mock.setProjectId(project.getId());
        mock.setName("mock");
        mock.setDescription("mock请求,返回mock结果");
        mock.setDefaultStatus(1);
        mock.setDisable(0);
        mock.setCanDelete(0);
        String port = appContext.getEnvironment().getProperty("server.port");
        port = port==null?"8080":port;
        mock.setHost("http://{服务器地址}/easyapi/doc/unified/mock?path=");
        execution.insert(mock);

        //添加本地环境
        DBModuleHostEntity local = new DBModuleHostEntity();
        local.setProjectId(project.getId());
        local.setModuleId(module.getId());
        local.setName("本地环境");
        local.setDescription("本机环境");
        local.setDefaultStatus(0);
        local.setDisable(0);
        mock.setCanDelete(1);
        String address = "localhost";
        try {
            address = InetAddress.getLocalHost().getHostAddress();
        } catch (UnknownHostException e) {
        }
        local.setHost("http://"+address+":"+port);
        execution.insert(local);
        return module;
    }

    /**
     * 初始化项目
     */
    private DBProjectEntity addDefaultProject() {
        //初始化项目
        DBProjectEntity project = new DBProjectEntity();
        project.setDefaultStatus(1);
        project.setTitle(all.getConfiguration().getTitle());
        project.setName(all.getConfiguration().getTitle());
        project.setDescription(ProjectContext.allConfiguration.getConfiguration().getDescription());
        execution.insert(project);
        return project;
    }

    /**
     * 添加默认用户
     */
    private void addDefaultUsers(DBModuleEntity module) {

        List<Integer> codes = AuthMoudle.allCode();
        //添加管理员账户
        DBUserEntity user = new DBUserEntity();
        user.setAccount(all.getUserConfiguration().getAccount());
        user.setPassword(StringUtil.toMD5(all.getUserConfiguration().getPassword()));
        user.setDisable(0);
        user.setDescription("超级管理员");
        user.setNickName("超级管理员");
        user.setSuperAdminStatus(1);
        user.setRoleId(0L);
        user.setHidden(1);
        user.setProjectId(module.getProjectId());
        user.setCreateTime(System.currentTimeMillis());
        user.setUpdateTime(System.currentTimeMillis());
        execution.insert(user);
        for (Integer code : codes) {
            DBUserTemporaryAuthEntity ua = new DBUserTemporaryAuthEntity();
            ua.setUserId(user.getId());
            ua.setAuthCode(code);
            execution.insert(ua);
        }

        //添加特殊超级管理员，该人员不可登陆，仅用作远程通讯
        DBUserEntity hiddenUser = new DBUserEntity();
        hiddenUser.setAccount("remote");
        hiddenUser.setPassword(StringUtil.toMD5("remote"));
        hiddenUser.setSuperAdminStatus(1);
        hiddenUser.setRoleId(0L);
        hiddenUser.setHidden(1);
        hiddenUser.setProjectId(module.getProjectId());
        hiddenUser.setCreateTime(System.currentTimeMillis());
        hiddenUser.setUpdateTime(System.currentTimeMillis());
        execution.insert(hiddenUser);

        //添加测试账号角色
        DBRoleEntity testRole = new DBRoleEntity();
        testRole.setRoleName("测试人员");
        testRole.setDescription("仅提供测试相关的权限");
        testRole.setSuperAdminStatus(0);
        testRole.setProjectId(module.getProjectId());
        testRole.setCreateTime(System.currentTimeMillis());
        testRole.setUpdateTime(System.currentTimeMillis());
        execution.insert(testRole);

        //添加角色对应的项目
        DBRoleProjectEntity roleProject = new DBRoleProjectEntity();
        roleProject.setRoleId(testRole.getId());
        roleProject.setProjectId(module.getProjectId());
        roleProject.setCreateTime(System.currentTimeMillis());
        roleProject.setUpdateTime(System.currentTimeMillis());
        execution.insert(roleProject);

        //添加角色对应的可操作功能
        List<Integer> defaultAuthCodes = AuthMoudle.getDefaultAuthCodes();
        List<DBRoleAuthEntity> auths = new ArrayList<>();
        List<DBUserTemporaryAuthEntity> uauths = new ArrayList<>();
        for (Integer code : defaultAuthCodes) {
            DBRoleAuthEntity entity = new DBRoleAuthEntity();
            entity.setRoleId(testRole.getId());
            entity.setAuthCode(code);
            entity.setModuleId(module.getId());
            entity.setProjectId(module.getProjectId());
            entity.setCreateTime(System.currentTimeMillis());
            entity.setUpdateTime(System.currentTimeMillis());
            auths.add(entity);
        }
        execution.insert(auths);

        //添加测试人员
        DBUserEntity test = new DBUserEntity();
        test.setAccount("test");
        test.setPassword(StringUtil.toMD5("test"));
        test.setSuperAdminStatus(0);
        test.setProjectId(module.getProjectId());
        test.setRoleId(testRole.getId());
        test.setNickName("测试账号");
        test.setDescription("测试人员账号");
        test.setDisable(0);
        execution.insert(test);
    }
}
