package cn.easyutil.easyapi.logic.js;

import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.StringUtil;
import com.github.javaparser.utils.StringEscapeUtils;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import java.util.HashMap;
import java.util.Map;

public class JavaScriptExec {

    public static String doSimpleExecute(Map<String,Object> source, String script){
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");
        try {
            if(StringUtil.isEmpty(script)){
                return null;
            }
            String doScript = "function getVal($data){return $_script;}";
            doScript = doScript.replace("$_script",script);
            engine.eval(doScript);
            // 可有调用方法
            Invocable invoke = (Invocable) engine;
            // 调用方法，此处无参数列表
            Object result = invoke.invokeFunction("getVal", source);
            if(result == null){
                return "";
            }
            if(ObjectUtil.isBaseObject(result)){
                return result.toString();
            }
            return JsonUtil.beanToJson(result);
        }catch (Exception e) {
            throw new ApidocException("脚本处理失败:"+script+"->"+e.getMessage());
        }
    }

    public static String doReplaceReqParams(Map<String,Object> source, String script){
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");
        try {
            if(StringUtil.isEmpty(script)){
                return null;
            }
            String doScript = "function getVal($data){var find=$_script;$_script='$_replace_val_';return find}";
            doScript = doScript.replace("$_script",script);
            engine.eval(doScript);
            // 可有调用方法
            Invocable invoke = (Invocable) engine;
            // 调用方法，此处无参数列表
            Object result = invoke.invokeFunction("getVal", source);
            if(result == null){
                return "";
            }
            if(ObjectUtil.isBaseObject(result)){
                return result.toString();
            }
            return JsonUtil.beanToJson(result);
        }catch (Exception e) {
            throw new ApidocException("脚本处理失败:"+script+"->"+e.getMessage());
        }
    }

    /**
     * 将参数转换
     * @param jsonParams    原始json参数
     * @param script    提取数据的脚本
     * @param parseType 编码/解码
     * @param parseKey  使用到的key
     * @param parseVariables    具体转换方法
     * @return  转换后的原始参数
     */
    public static String parseParams(String jsonParams,String script,String parseType,String parseKey,ParseVariables parseVariables){
        if(StringUtil.isEmpty(script) || StringUtil.isEmpty(jsonParams)){
            return "";
        }
        if(StringUtil.isEmpty(parseType)){
            parseType = "encode";
        }
        try {
            //外面包装一层，避免全参数替换的时候无效
            Map<String, Object> source = null;
            //是否全部参数转换
            boolean isroot = script.equals("$data");
            String replaceVal = jsonParams;
            if(!script.equals("$data")){
                source = JsonUtil.jsonToMap(replaceVal);
                replaceVal = JavaScriptExec.doReplaceReqParams(source, script);
            }
            if(StringUtil.isEmpty(replaceVal)){
                return jsonParams;
            }
            String params = isroot?"$_replace_val_":JsonUtil.beanToJson(source);
            if(parseVariables instanceof OverwriteParseVariables && !StringUtil.isEmpty(parseKey)){
                if(!parseKey.equals("$data")){
                    JavaScriptExec.doReplaceReqParams(source, parseKey);
                    params = JsonUtil.beanToJson(source);
                }else{
                    params = "$_replace_val_";
                }
            }
            boolean encode = parseType.trim().toLowerCase().equals("encode");
            String parseParam =  encode?parseVariables.encode(replaceVal,parseKey):parseVariables.decode(replaceVal,parseKey);
            return params.replace("$_replace_val_",parseParam);
        }catch (Exception e) {
            throw new ApidocException("脚本处理失败:"+script+"->"+e.getMessage());
        }
    }

    public static void main(String[] args) {
        Map<String,Object> map = new HashMap<>();
        map.put("name","xiaoming");
        map.put("age",12);
        String s = StringEscapeUtils.escapeJava("fdsfsd");
        System.out.println(s);
    }
}
