package cn.easyutil.easyapi.logic.el;

import cn.easyutil.easyapi.util.StringUtil;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultSpelMethodParser extends SpelParser{

    private static DefaultSpelMethodParser parser = new DefaultSpelMethodParser();

    /**
     * 获取单例对象
     * @return
     */
    public static DefaultSpelMethodParser get(){
        return parser;
    }

    @Override
    protected boolean isVariable(String variableEl) {
        return variableEl!=null && variableEl.startsWith("@") && variableEl.contains("(") && variableEl.contains(")");
    }

    @Override
    protected boolean isString(Object parseVal) {
        return false;
    }

    @Override
    protected Object parseVariable(String variableEl) {
        String methodEl = variableEl.substring(1);
        String methodName = methodEl.substring(0, methodEl.indexOf("("));
        String parameter = methodEl.substring(methodEl.indexOf("(")+1, methodEl.indexOf(")"));
        int parameterLength = Stream.of(parameter.split(",")).filter(s-> !StringUtil.isEmpty(s)).collect(Collectors.toSet()).size();
        String methodClassName = getMethodClassName(methodName, parameterLength);
        return variableEl.replace("@","T("+methodClassName+").");
    }

    @Override
    protected List<String> getCustomVariables(String el) {
        String parse = el;
        List<String> methods = new ArrayList<>();
        while (parse.startsWith("@") && parse.contains("(") && parse.contains(")")){
            String methodEl = parse.substring(0,parse.indexOf(")")+1);
            parse = parse.replace(methodEl, "");
            methods.add(methodEl);
        }
        return methods;
    }

    /**
     * 获取方法所在的类名
     * @param methodName    方法名
     * @param parameterLength   方法参数数量
     * @return
     */
    protected String getMethodClassName(String methodName,int parameterLength){
        return "cn.easyutil.easyapi.logic.el.ElDefaultMethodContext";
    }
}
