package cn.easyutil.easyapi.logic.el;

import java.util.HashMap;
import java.util.Map;

/**
 * 存放当前项目全部环境变量
 */
public class ApiEvaluationContext {

    //公共请求头
    private Map<String,Object> header = new HashMap<>();
    //项目环境信息
    private Map<String,Object> env = new HashMap<>();
    //接口响应参数
    private Map<String,Object> response = new HashMap<>();
    //请求环境，包含上次存储
    private Map<String,Object> request = new HashMap<>();
    //用户自己保存的变量信息
    private Map<String,Object> current = new HashMap<>();

    //表达式支持的命令

    public void addHeader(String key,Object val){
        add(this.header, key, val);
    }
    public void addEnv(String key,Object val){
        add(this.env, key, val);
    }
    public void addResponse(String key,Object val){
        add(this.response, key, val);
    }
    public void addRequest(String key,Object val){
        add(this.request, key, val);
    }
    public void addCurrent(String key,Object val){add(this.current, key, val);}

    private void add(Map<String,Object> source,String key,Object val){
        if(source == null){
            return ;
        }
        if(key==null || val==null){
            return ;
        }
        source.put(key, val);
    }

    public Map<String, Object> getHeader() {
        return header;
    }

    public void setHeader(Map<String, Object> headers) {
        this.header = headers;
    }

    public Map<String, Object> getEnv() {
        return env;
    }

    public void setEnv(Map<String, Object> envs) {
        this.env = envs;
    }

    public Map<String, Object> getResponse() {
        return response;
    }

    public void setResponse(Map<String, Object> response) {
        this.response = response;
    }

    public Map<String, Object> getRequest() {
        return request;
    }

    public void setRequest(Map<String, Object> request) {
        this.request = request;
    }

    public Map<String, Object> getCurrent() {
        return current;
    }

    public void setCurrent(Map<String, Object> current) {
        this.current = current;
    }
}
