package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.datasource.bean.EasyApiBindSqlResult;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHeaderEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleScriptEntity;
import cn.easyutil.easyapi.entity.db.doc.DBMouduleEnvEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestGroupEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestInfoEntity;
import cn.easyutil.easyapi.entity.db.unit.DBSimpleUnitEntity;
import cn.easyutil.easyapi.interview.dto.AfterScriptDto;
import cn.easyutil.easyapi.interview.dto.DoSimpleUnitDto;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.dto.SelectGroupsDto;
import cn.easyutil.easyapi.interview.entity.HttpEntity;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.interview.vo.DoSimpleUnitVo;
import cn.easyutil.easyapi.logic.js.JavaScriptExec;
import cn.easyutil.easyapi.logic.js.ParseVariablesFactory;
import cn.easyutil.easyapi.logic.unit.ComplexTestProcess;
import cn.easyutil.easyapi.service.SimpleUnitService;
import cn.easyutil.easyapi.service.TestGroupService;
import cn.easyutil.easyapi.service.TestInfoService;
import cn.easyutil.easyapi.service.TestService;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import cn.easyutil.easyapi.util.http.HttpRes;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.*;

/**
 * 单元测试
 */
@RestController
@ConditionalOnMissingBean(name = "easyapiUnitController")
@RequestMapping("/easyapi/doc/unit")
public class UnitController {

    @Resource(name = "easyapiTestGroupService")
    private TestGroupService groupService;

    @Resource(name = "easyapiTestService")
    private TestService testService;

    @Resource(name = "easyapiTestInfoService")
    private TestInfoService testInfoService;

    @Resource(name = "easyapiSimpleUnitService")
    private SimpleUnitService simpleUnitService;

    @Resource(name = "easyapiSimpleApidocController")
    private SimpleApidocController simpleApidocController;

    @ApidocComment("条件查询接口测试分组列表")
    @PostMapping("/selectGroups")
    @AccessAuth(code = 1000)
    public EasyApiBindSqlResult<DBComplexTestGroupEntity> selectGroups(@RequestBody SelectGroupsDto dto){
        DBComplexTestGroupEntity query = new DBComplexTestGroupEntity();
        BeanUtils.copyProperties(dto, query);
        query.setName(null);
        EasyApiBindSqlResult page = groupService.page(EasyapiBindSQLExecuter.build(query)
                        .like(!StringUtil.isEmpty(dto.getName()), DBComplexTestGroupEntity::getName, dto.getName())
                , dto.getCurrentPage(), dto.getShowCount()
        );
        return page;
    }

    @ApidocComment("添加接口测试分组")
    @PostMapping("/addGroups")
    @AccessAuth(code = 1000)
    public void addGroups(@RequestBody DBComplexTestGroupEntity entity){
        AssertUtil.isEmpty(entity.getName(), "分组名称不能为空");
        groupService.insert(entity);
    }

    @ApidocComment("修改接口测试分组")
    @PostMapping("/updateGroups")
    @AccessAuth(code = 1000)
    public void updateGroups(@RequestBody DBComplexTestGroupEntity entity){
        AssertUtil.isNull(entity.getId(), "分组id不能为空");
        groupService.update(entity);
    }

    @ApidocComment("删除接口测试分组")
    @PostMapping("/delGroups")
    @AccessAuth(code = 1000)
    public void delGroups(@RequestBody IdDto dto){
        groupService.deleteById(dto.getId());
    }

    @ApidocComment("条件查询接口测试历史")
    @PostMapping("/selectTests")
    @AccessAuth(code = 1000)
    public EasyApiBindSqlResult<DBComplexTestEntity> selectTests(@RequestBody SelectGroupsDto dto){
        DBComplexTestEntity query = new DBComplexTestEntity();
        BeanUtils.copyProperties(dto, query);
        EasyApiBindSqlResult page = testService.page(EasyapiBindSQLExecuter.build(query)
                        .like(!StringUtil.isEmpty(dto.getName()), DBComplexTestGroupEntity::getName, dto.getName())
                , dto.getCurrentPage(), dto.getShowCount()
        );
        return page;
    }

    @ApidocComment("删除接口测试历史")
    @PostMapping("/delTests")
    @AccessAuth(code = 1000)
    public void delTests(@RequestBody IdDto dto){
        testService.deleteById(dto.getId());
        DBComplexTestInfoEntity entity = new DBComplexTestInfoEntity();
        entity.setTestId(dto.getId());
        testInfoService.delete(entity);
    }

    @ApidocComment("获取上次接口执行相关参数")
    @AccessAuth(code = 1000)
    public DBSimpleUnitEntity getLastUnit(@RequestBody IdDto dto){
        DBSimpleUnitEntity unit = new DBSimpleUnitEntity();
        unit.setInterfaceId(dto.getId());
        unit.setUserId(CurrentSession.getCurrentUser().getId());
        unit.setProjectId(CurrentSession.getCurrentProjectId());
        return simpleUnitService.get(unit);
    }

    @ApidocComment("执行网络请求")
    @AccessAuth(code = 1000)
    public DoSimpleUnitVo doSimpleUnit(@RequestBody DoSimpleUnitDto entity){
        List<DBModuleScriptEntity> reqScript = new ArrayList<>();
        List<DBModuleScriptEntity> afterScript = new ArrayList<>();
        if(entity.getScripts()!=null && !entity.getScripts().isEmpty()){
            List<DBModuleScriptEntity> scripts = entity.getScripts();
            for (DBModuleScriptEntity script : scripts) {
                String valType = script.getValType();
                if(StringUtil.isEmpty(valType)){
                    continue;
                }
                if(valType.equals("req")){
                    reqScript.add(script);
                }else{
                    afterScript.add(script);
                }
            }
        }
        for (DBModuleScriptEntity script : reqScript) {
            String params = JavaScriptExec.parseParams(entity.getJsonParams(), script.getScript(), script.getParseType(), script.getParseKey(), ParseVariablesFactory.get(script.getValName()));
            entity.setJsonParams(params);
        }
        long startTime = System.currentTimeMillis();
        HttpRes httpRes = ComplexTestProcess.doUrl(entity, true);
        long endTime = System.currentTimeMillis();
        httpRes.getResponseMsg();
        DoSimpleUnitVo result = new DoSimpleUnitVo();
        result.setResponseCode(httpRes.getResponseCode());
        result.setResponseMsg(httpRes.getResponseMsg());
        result.setResponseHeaders(httpRes.getResponseHeaders());
        result.setAnswerTime(endTime-startTime);
        if(httpRes.getResponseCode() != 200){
            return result;
        }
        //将执行记录保存到DB
        Long userId = CurrentSession.getCurrentUser().getId();
        Long interfaceId = entity.getInterfaceId();
        String jsonParams = entity.getSaveParamsJson();
        String jsonHeaders = entity.getSaveHeadersJson();
        String responseMsg = httpRes.getResponseMsg();
        DBSimpleUnitEntity unit = new DBSimpleUnitEntity();
        unit.setProjectId(CurrentSession.getCurrentProjectId());
        unit.setInterfaceId(interfaceId);
        unit.setUserId(userId);
        DBSimpleUnitEntity query = simpleUnitService.get(unit);
        if(query != null){
            simpleUnitService.deleteById(query.getId());
        }
        unit.setJsonHeaders(jsonHeaders);
        unit.setJsonParameters(jsonParams);
        unit.setJsonResponse(responseMsg);
        unit.setJsonPackages(entity.getSavePackageJson());
        unit.setJsonTables(entity.getSaveTableJson());
        unit.setJsonScripts(entity.getScripts()==null?"[]":JsonUtil.beanToJson(entity.getScripts()));
        unit.setJsonResHeaders(JsonUtil.beanToJson(httpRes.getResponseHeaders()));
        unit.setAnswerTime(endTime-startTime);
        //处理后续操作
        if(afterScript.isEmpty() || StringUtil.isEmpty(responseMsg)){
            simpleUnitService.insert(unit);
            return result;
        }
        for (DBModuleScriptEntity dto : afterScript) {
            if(StringUtil.isEmpty(dto.getValType()) || StringUtil.isEmpty(dto.getScript())){
                continue;
            }
            String valType = dto.getValType().toLowerCase().trim();
            if(valType.equals("res")){
                String params = JavaScriptExec.parseParams(result.getResponseMsg(), dto.getScript(), dto.getParseType(), dto.getParseKey(), ParseVariablesFactory.get(dto.getValName()));
                result.setResponseMsg(params);
                responseMsg = params;
                continue;
            }
            String script = dto.getScript().trim();
            String val = responseMsg;
            if(!script.equals("$data")){
                val = JavaScriptExec.doSimpleExecute(JsonUtil.jsonToMap(responseMsg), script);
            }
            if(StringUtil.isEmpty(val)){
                continue;
            }
            if(valType.equals("header")){
                //将变量值设置到header
                DBModuleHeaderEntity header = new DBModuleHeaderEntity();
                header.setKey(dto.getValName());
                header.setVal(val);
                header.setModuleId(CurrentSession.getCurrentModuleId());
                header.setProjectId(CurrentSession.getCurrentProjectId());
                header.setUserId(CurrentSession.getCurrentUser().getId());
                simpleApidocController.addHeader(header);
            }else if(valType.equals("env")){
                DBMouduleEnvEntity env = new DBMouduleEnvEntity();
                env.setName(Optional.ofNullable(dto.getDescription()).orElse(dto.getValName()));
                env.setKey(dto.getValName());
                env.setVal(val);
                env.setModuleId(CurrentSession.getCurrentModuleId());
                env.setProjectId(CurrentSession.getCurrentProjectId());
                env.setUserId(CurrentSession.getCurrentUser().getId());
                simpleApidocController.addEnv(env);
            }
        }
        unit.setJsonResponse(result.getResponseMsg());
        simpleUnitService.insert(unit);
        return result;
    }

}
