package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.interview.vo.GetIndexTextVo;
import cn.easyutil.easyapi.service.ProjectService;
import cn.easyutil.easyapi.util.AssertUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.Set;

@RestController
@ConditionalOnMissingBean(name = "easyapiProjectController")
@RequestMapping("/easyapi/doc/project")
public class ProjectController {

    @Resource(name = "easyapiProjectService")
    private ProjectService projectService;

    @ApidocComment("获取项目列表")
    @PostMapping("/getProjects")
    @AccessAuth(code = 1000)
    public List<DBProjectEntity> getProjects(){
        Set<Long> longs = CurrentSession.getCurrentUser().getProjectIds().keySet();
        List<DBProjectEntity> list = projectService.list(EasyapiBindSQLExecuter.build(new DBProjectEntity()).in(DBProjectEntity::getId, longs));
        return list;
    }

    @ApidocComment("修改项目信息")
    @PostMapping("/updateProjects")
    @AccessAuth(code = 1000)
    public void updateProjects(@RequestBody DBProjectEntity entity){
        AssertUtil.isNull(entity.getId(), "项目id不能为空");
        if(entity.getDefaultStatus()!=null && entity.getDefaultStatus()==1){
            DBProjectEntity query = new DBProjectEntity();
            query.setDefaultStatus(entity.getDefaultStatus());
            query = projectService.get(query);
            AssertUtil.isTrue(query!=null, "只能有一个默认项目");
        }
        projectService.update(entity);
    }

    @ApidocComment("新增项目")
    @PostMapping("/addProject")
    @AccessAuth(code = 1000)
    public void addProject(@RequestBody DBProjectEntity entity){
        if(entity.getDefaultStatus()!=null && entity.getDefaultStatus()==1){
            DBProjectEntity query = new DBProjectEntity();
            query.setDefaultStatus(entity.getDefaultStatus());
            query = projectService.get(query);
            AssertUtil.isTrue(query!=null, "只能有一个默认项目");
        }
        projectService.insert(entity);
    }

    @ApidocComment("删除项目")
    @PostMapping("/delProject")
    @AccessAuth(code = 1000)
    public void delProject(@RequestBody IdDto dto){
        projectService.deleteById(dto.getId());
    }

    @ApidocComment("获取项目信息")
    @PostMapping("/getInfo")
    @AccessAuth(code = 1000)
    public DBProjectEntity getInfo(){
        return projectService.get(new DBProjectEntity());
    }
}
