package cn.easyutil.easyapi.filter.model;

import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.ReadJavaBeanApiFilter;
import cn.easyutil.easyapi.logic.creator.CreatorCommonMethod;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.util.AnnotationUtil;
import cn.easyutil.easyapi.util.StringUtil;
import org.springframework.web.multipart.MultipartFile;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;

/**
 * 读取文档时的配置
 */
public class DefaultReadJavaBeanApi extends ReadJavaBeanApiFilter {


    @Override
    public JavaType javaType(Class aClass, GenericTypeBind bind, Type type, ApiExtra extra) {
        if(type.equals(BigDecimal.class)){
            return JavaType.Long;
        }
        if(type.equals(Date.class) || type.equals(java.sql.Date.class) || type.equals(LocalDate.class) || type.equals(LocalDateTime.class)){
            return JavaType.Long;
        }
        if(type instanceof Class){
            if(MultipartFile.class.isAssignableFrom((Class<?>) type)){
                return JavaType.File;
            }
        }
        return JavaType.getJavaTypeByType(type);
    }

    @Override
    public Type type(Class aClass, GenericTypeBind bind, Type type, ApiExtra extra) {
        return type;
    }

    @Override
    public String description(Class aClass, GenericTypeBind bind, Field field, ApiExtra extra) {
        ApidocComment api = field.getDeclaredAnnotation(ApidocComment.class);
        if(api!=null && !StringUtil.isEmpty(api.value())){
            return api.value();
        }
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiModelProperty", field.getAnnotations());
        if(annotation != null){
            Object value = AnnotationUtil.getAnnotationValue(annotation, "value");
            if(!StringUtil.isEmpty(value)){
                return value.toString();
            }
        }
        return extra.getFieldComment().getComment();
    }

    @Override
    public String mockTemplate(Class aClass, GenericTypeBind bind,Field field, ApiExtra extra) {
        return CreatorCommonMethod.mockTemplate(field.getAnnotations());
    }

    @Override
    public boolean required(Class aClass, GenericTypeBind bind,Field field, ApiExtra extra) {
        ApidocComment api = field.getDeclaredAnnotation(ApidocComment.class);
        if(api!=null){
            return api.required();
        }
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiModelProperty", field.getAnnotations());
        if(annotation != null){
            Object required = AnnotationUtil.getAnnotationValue(annotation, "required");
            return (boolean) required;
        }
        return false;
    }

    @Override
    public boolean show(Class aClass, GenericTypeBind bind, Field field, ApiExtra extra) {
        ApidocComment api = field.getDeclaredAnnotation(ApidocComment.class);
        if(api!=null){
            return !api.hidden();
        }
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiModelProperty", field.getAnnotations());
        if(annotation != null){
            Object hidden = AnnotationUtil.getAnnotationValue(annotation, "hidden");
            if(hidden!=null && hidden instanceof Boolean){
                Boolean h = (Boolean) hidden;
                return !h;
            }
        }
        return true;
    }

    @Override
    public boolean ignore(Class aClass, GenericTypeBind bind, Field field, ApiExtra extra) {
        if(field.getType().isAssignableFrom(Serializable.class) && field.getGenericType()==null){
            return true;
        }
        if(field.getName().equals("serialVersionUID")){
            return true;
        }
        if(field.getName().startsWith("java.") || field.getName().startsWith("javax.") || field.getName().startsWith("sun.")){
            return true;
        }
        ApidocComment api = field.getDeclaredAnnotation(ApidocComment.class);
        if(api!=null){
            return api.ignore();
        }
        if(field.getType().equals(Class.class)){
            return true;
        }
        return false;
    }

    @Override
    public List<String> conditons(Class aClass, GenericTypeBind bind, Field field, ApiExtra extra) {
        Annotation[] annotations = field.getAnnotations();
        return CreatorCommonMethod.readConditons(annotations);
    }
}
