package cn.easyutil.easyapi.filter;

import cn.easyutil.easyapi.entity.common.BodyType;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.javadoc.reader.ClassComment;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import org.springframework.web.bind.annotation.*;

import java.lang.reflect.Method;
import java.util.List;

/**
 * 读取接口方法相关的api
 */
public abstract class ReadInterfaceApiFilter{

    public abstract List<Method> readAllInterfaces(Class controller, ApiExtra extra);

    /**
     * 读取接口是否忽略
     * @param method
     * @return  true：忽略  false：非忽略
     */
    public abstract boolean ignore(Method method, ApiExtra extra);


    /**
     * 读取接口请求体类型
     * @param method
     * @return
     */
    public abstract BodyType bodyType(Method method, ApiExtra extra);

    /**
     * 读取接口请求路径
     * @param method    接口方法
     * @return  请求路径
     */
    public abstract String requestUrl(Method method, ApiExtra extra);

    /**
     * 读取接口请求方式
     * @param method    接口方法
     * @return  请求路径
     */
    public abstract RequestMethod requestMethod(Method method, ApiExtra extra);

    /**
     * 读取接口名称
     * @param method    接口方法
     * @return  接口名称
     */
    public abstract String showName(Method method, ApiExtra extra);

    /**
     * 读取接口说明
     * @param method    接口方法
     * @return  接口说明
     */
    public abstract String description(Method method, ApiExtra extra);

    /**
     * 接口唯一标识
     * @param method
     * @return
     */
    public abstract String unique(Method method, ApiExtra extra);

}
