package cn.easyutil.easyapi.filter;

import cn.easyutil.easyapi.javadoc.reader.ClassComment;
import org.springframework.context.ApplicationContext;

import java.util.Set;

public abstract class ReadControllerApiFilter {

    /**
     * 读取需要展示的controller
     * @param springContext spring容器
     * @return
     */
    public abstract Set<Class> readControllers(ApplicationContext springContext);

    /**
     * 读取controller是否忽略
     * @param controller
     * @return  true：忽略  false：非忽略
     */
    public abstract boolean ignore(Class controller, ApiExtra extra);

    /**
     * 读取controller名称
     * @param controller    controller类
     * @return  controller名称
     */
    public abstract String showName(Class controller, ApiExtra extra);

    /**
     * 读取controller上的父路径
     * @param controller
     * @return  父路径
     */
    public abstract String requestPath(Class controller, ApiExtra extra);

    /**
     * 控制器描述
     * @param controller
     * @return
     */
    public abstract String description(Class controller, ApiExtra extra);

    /**
     * 控制器作者
     * @param controller
     * @return
     */
    public abstract String author(Class controller, ApiExtra extra);
}
