package cn.easyutil.easyapi.entity.db.unit;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.logic.js.JavaScriptExec;
import cn.easyutil.easyapi.logic.unit.OperEnum;
import cn.easyutil.easyapi.util.JsonUtil;

import javax.script.*;
import java.sql.Blob;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * 简单测试
 */
@Tne("EASYAPI_SIMPLE_UNIT")
public class DBSimpleUnitEntity extends BaseDbEntity {

    @Tfd("USER_ID")
    @ApidocComment("用户id")
    private Long userId;

    @Tfd("INTERFACE_ID")
    @ApidocComment("接口id")
    private Long interfaceId;

    @Tfd(value = "JSON_PARAMETERS",type = Blob.class)
    @ApidocComment("请求参数")
    private String jsonParameters;

    @Tfd(value = "JSON_TABLES",type = Blob.class)
    @ApidocComment("table请求参数")
    private String jsonTables;

    @Tfd(value = "JSON_PACKAGES",type = Blob.class)
    @ApidocComment("请求参数包装")
    private String jsonPackages;

    @Tfd(value = "JSON_HEADERS",type = Blob.class)
    @ApidocComment("请求头")
    private String jsonHeaders;

    @Tfd(value = "JSON_RESPONSE",type = Blob.class)
    @ApidocComment("接口响应结果")
    private String jsonResponse;

    @Tfd(value = "JSON_RES_HEADERS",type = Blob.class)
    @ApidocComment("接口响应header")
    private String jsonResHeaders;

    @Tfd("ANSWER_TIME")
    @ApidocComment("接口响应时间")
    private Long answerTime;

    @Tfd(value = "JSON_SCRIPTS",type = Blob.class)
    @ApidocComment("后置处理")
    private String jsonScripts;


    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getInterfaceId() {
        return interfaceId;
    }

    public void setInterfaceId(Long interfaceId) {
        this.interfaceId = interfaceId;
    }

    public String getJsonParameters() {
        return jsonParameters;
    }

    public void setJsonParameters(String jsonParameters) {
        this.jsonParameters = jsonParameters;
    }

    public String getJsonHeaders() {
        return jsonHeaders;
    }

    public void setJsonHeaders(String jsonHeaders) {
        this.jsonHeaders = jsonHeaders;
    }

    public String getJsonResponse() {
        return jsonResponse;
    }

    public void setJsonResponse(String jsonResponse) {
        this.jsonResponse = jsonResponse;
    }

    public String getJsonPackages() {
        return jsonPackages;
    }

    public void setJsonPackages(String jsonPackages) {
        this.jsonPackages = jsonPackages;
    }

    public String getJsonTables() {
        return jsonTables;
    }

    public void setJsonTables(String jsonTables) {
        this.jsonTables = jsonTables;
    }

    public String getJsonScripts() {
        return jsonScripts;
    }

    public void setJsonScripts(String jsonScripts) {
        this.jsonScripts = jsonScripts;
    }

    public String getJsonResHeaders() {
        return jsonResHeaders;
    }

    public void setJsonResHeaders(String jsonResHeaders) {
        this.jsonResHeaders = jsonResHeaders;
    }

    public Long getAnswerTime() {
        return answerTime;
    }

    public void setAnswerTime(Long answerTime) {
        this.answerTime = answerTime;
    }

    public static void main(String[] args) throws ScriptException, NoSuchMethodException {
        Map<String,Object> source = new HashMap<>();
        source.put("name","honghong");
        DBUserEntity userEntity = new DBUserEntity();
        userEntity.setPassword("123456");
        userEntity.setAccount("admin");
        source.put("user", Arrays.asList(userEntity));
        String result = JavaScriptExec.doSimpleExecute(source, "$res.user[0].password");
        System.out.println(result);
    }
}
