package cn.easyutil.easyapi.entity.db.unit;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.logic.unit.OperEnum;

import java.sql.Blob;

/**
 * 测试详细数据
 */
@Tne("EASYAPI_COMPLEX_TEST_INFO")
public class DBComplexTestInfoEntity extends BaseDbEntity {

    @Tfd("TEST_ID")
    @ApidocComment("单元测试id")
    private Long testId;

    @Tfd("INTERFACE_ID")
    @ApidocComment("接口id")
    private Long interfaceId;

    @Tfd("HTTP_STATUS")
    @ApidocComment("http状态码")
    private Integer httpStatus;

    @Tfd("SUCCESS_KEY")
    @ApidocComment("接口成功标志的key(取结果集字段,嵌套使用.获取属性)")
    private String successKey;

    /**
     * @see OperEnum
     */
    @Tfd("SUCCESS_OPER")
    @ApidocComment("接口成功标志的key对应的运算符")
    private String successOper;

    @Tfd("SUCCESS_VAL")
    @ApidocComment("接口成功标志的key对应的运算符计算后的结果")
    private String successVal;

    @Tfd("REAL_VAL")
    @ApidocComment("真实返回的值")
    private String realVal;

    @Tfd("REQUEST_HEADERS")
    @ApidocComment("请求头")
    private String requestHeaders;

    @Tfd("REQUEST_PARAM")
    @ApidocComment("请求参数")
    private String requestParam;

    @Tfd("RESPONSE_HEADERS")
    @ApidocComment("响应头")
    private String responseHeaders;

    @Tfd(value = "RESPONSE_PARAM",type = Blob.class)
    @ApidocComment("响应结果")
    private String responseResult;

    @Tfd("SUCCESS_STATUS")
    @ApidocComment("0-失败 1-成功")
    private Integer successStatus;

    public Long getTestId() {
        return testId;
    }

    public void setTestId(Long testId) {
        this.testId = testId;
    }

    public Integer getHttpStatus() {
        return httpStatus;
    }

    public void setHttpStatus(Integer httpStatus) {
        this.httpStatus = httpStatus;
    }

    public String getRequestHeaders() {
        return requestHeaders;
    }

    public void setRequestHeaders(String requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public String getRequestParam() {
        return requestParam;
    }

    public void setRequestParam(String requestParam) {
        this.requestParam = requestParam;
    }

    public String getResponseHeaders() {
        return responseHeaders;
    }

    public void setResponseHeaders(String responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public String getResponseResult() {
        return responseResult;
    }

    public void setResponseResult(String responseResult) {
        this.responseResult = responseResult;
    }

    public Integer getSuccessStatus() {
        return successStatus;
    }

    public void setSuccessStatus(Integer successStatus) {
        this.successStatus = successStatus;
    }

    public String getSuccessKey() {
        return successKey;
    }

    public void setSuccessKey(String successKey) {
        this.successKey = successKey;
    }

    public String getSuccessOper() {
        return successOper;
    }

    public void setSuccessOper(String successOper) {
        this.successOper = successOper;
    }

    public String getSuccessVal() {
        return successVal;
    }

    public void setSuccessVal(String successVal) {
        this.successVal = successVal;
    }

    public String getRealVal() {
        return realVal;
    }

    public void setRealVal(String realVal) {
        this.realVal = realVal;
    }

    public Long getInterfaceId() {
        return interfaceId;
    }

    public void setInterfaceId(Long interfaceId) {
        this.interfaceId = interfaceId;
    }
}
