package cn.easyutil.easyapi.entity.db.unit;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;

import java.util.List;

/**
 * 复杂测试配置类
 */
@Tne("EASYAPI_COMPLEX_TEST_GROUP")
public class DBComplexTestGroupEntity extends BaseDbEntity {

    @Tfd("INTERFACE_ID")
    @ApidocComment("接口id")
    private Long interfaceId;

    @Tfd("NAME")
    @ApidocComment("配置名称")
    private String name;

    @Tfd("THREAD_COUNT")
    @ApidocComment("线程数")
    private Integer threadCount;

    @Tfd("REQUEST_HEADERS")
    @ApidocComment("请求头")
    private String requestHeaders;

    @Tfd("REQUEST_PARAM")
    @ApidocComment("请求参数")
    private String requestParam;

    @Tfd("USER_ID")
    @ApidocComment("用户id")
    private Long userId;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getThreadCount() {
        return threadCount;
    }

    public void setThreadCount(Integer threadCount) {
        this.threadCount = threadCount;
    }

    public String getRequestHeaders() {
        return requestHeaders;
    }

    public void setRequestHeaders(String requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public String getRequestParam() {
        return requestParam;
    }

    public void setRequestParam(String requestParam) {
        this.requestParam = requestParam;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getInterfaceId() {
        return interfaceId;
    }

    public void setInterfaceId(Long interfaceId) {
        this.interfaceId = interfaceId;
    }
}
