package cn.easyutil.easyapi.entity.db.unit;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.logic.unit.OperEnum;

/**
 * 复杂测试
 */
@Tne("EASYAPI_COMPLEX_TEST")
public class DBComplexTestEntity extends BaseDbEntity {

    @Tfd("USER_ID")
    @ApidocComment("用户id")
    private Long userId;

    @Tfd("INTERFACE_ID")
    @ApidocComment("接口id")
    private Long interfaceId;

    @Tfd("GROUP_IDS")
    @ApidocComment("分组id集合，多条逗号分隔")
    private String groupIds;

    @Tfd("SUCCESS_KEY")
    @ApidocComment("接口成功标志的key(取结果集字段,嵌套使用.获取属性)")
    private String successKey;

    /**
     * @see OperEnum
     */
    @Tfd("SUCCESS_OPER")
    @ApidocComment("接口成功标志的key对应的运算符")
    private String successOper;

    @Tfd("SUCCESS_VAL")
    @ApidocComment("接口成功标志的key对应的运算符计算后的结果")
    private String successVal;

    @Tfd("TIME_CONSUMING")
    @ApidocComment("耗时")
    private Long timeConsuming;

    @Tfd("SUCCESS_COUNT")
    @ApidocComment("成功数")
    private Integer successCount;

    @Tfd("FAIL_COUNT")
    @ApidocComment("失败数")
    private Integer failCount;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getInterfaceId() {
        return interfaceId;
    }

    public void setInterfaceId(Long interfaceId) {
        this.interfaceId = interfaceId;
    }

    public String getSuccessKey() {
        return successKey;
    }

    public void setSuccessKey(String successKey) {
        this.successKey = successKey;
    }

    public String getSuccessOper() {
        return successOper;
    }

    public void setSuccessOper(String successOper) {
        this.successOper = successOper;
    }

    public String getSuccessVal() {
        return successVal;
    }

    public void setSuccessVal(String successVal) {
        this.successVal = successVal;
    }

    public Long getTimeConsuming() {
        return timeConsuming;
    }

    public void setTimeConsuming(Long timeConsuming) {
        this.timeConsuming = timeConsuming;
    }

    public Integer getSuccessCount() {
        return successCount;
    }

    public void setSuccessCount(Integer successCount) {
        this.successCount = successCount;
    }

    public Integer getFailCount() {
        return failCount;
    }

    public void setFailCount(Integer failCount) {
        this.failCount = failCount;
    }

    public String getGroupIds() {
        return groupIds;
    }

    public void setGroupIds(String groupIds) {
        this.groupIds = groupIds;
    }
}
