package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;

/**
 * 模块全局脚本
 */
@Tne("EASYAPI_MODULE_SCRIPT")
public class DBModuleScriptEntity extends BaseDbEntity {

    @Tfd("MODULE_ID")
    @ApidocComment("模块id")
    private Long moduleId;

    @Tfd("USER_ID")
    @ApidocComment("用户id")
    private Long userId;

    @Tfd("DESCRIPTION")
    @ApidocComment("脚本说明")
    private String description;

    @Tfd("VAL_NAME")
    @ApidocComment("要处理的字段名称")
    private String valName;

    @Tfd("VAL_TYPE")
    @ApidocComment("脚本要操作的数据  header,env,req,res")
    private String valType;

    @Tfd("SCRIPT")
    @ApidocComment("具体脚本")
    private String script;

    @Tfd("PARSE_KEY")
    @ApidocComment("处理参数时的方法密钥")
    private String parseKey;

    @Tfd("PARSE_TYPE")
    @ApidocComment("处理方式  encode/decode")
    private String parseType;

    @Tfd("SORT")
    @ApidocComment("排序")
    private Integer sort;

    public Long getModuleId() {
        return moduleId;
    }

    public void setModuleId(Long moduleId) {
        this.moduleId = moduleId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getValName() {
        return valName;
    }

    public void setValName(String valName) {
        this.valName = valName;
    }

    public String getValType() {
        return valType;
    }

    public void setValType(String valType) {
        this.valType = valType;
    }

    public String getScript() {
        return script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getParseKey() {
        return parseKey;
    }

    public void setParseKey(String parseKey) {
        this.parseKey = parseKey;
    }

    public String getParseType() {
        return parseType;
    }

    public void setParseType(String parseType) {
        this.parseType = parseType;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }
}
