package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tie;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;

/**
 * 返回数据外包装
 * @author spc
 *
 */
@Tne("EASYAPI_MODULE_OUT_PACKAGE")
public class DBModuleOutPackageEntity extends BaseDbEntity {

	@Tfd("MODULE_ID")
	@ApidocComment("所属模块id")
	private Long moduleId;

	@Tfd("KEY")
	@ApidocComment("包装的key")
	private String key;

	@Tfd("TYPE")
	@ApidocComment("类型  0-请求参数包装  1-响应参数包装")
	private Integer type;

	@Tfd("VAL")
	@ApidocComment("包装的val,如果是默认，则会替换真实数据")
	private String val;

	@Tfd("DEFAULT_STATUS")
	@ApidocComment("默认状态：0-缺省默认值  1-数据包装")
	private Integer defaultStatus;

	public Long getModuleId() {
		return moduleId;
	}

	public void setModuleId(Long moduleId) {
		this.moduleId = moduleId;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getVal() {
		return val;
	}

	public void setVal(String val) {
		this.val = val;
	}

	public Integer getDefaultStatus() {
		return defaultStatus;
	}

	public void setDefaultStatus(Integer defaultStatus) {
		this.defaultStatus = defaultStatus;
	}
}
