package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.util.StringUtil;
import org.springframework.web.bind.annotation.RequestMethod;

import java.sql.Blob;

/**
 * 接口
 */
@Tne("EASYAPI_MODULE_INTERFACE")
public class DBModuleInterfaceEntity extends BaseDbEntity {

	@Tfd("MODULE_ID")
	@ApidocComment("模块id")
	private Long moduleId;

	@Tfd("CONTROLLER_ID")
 	@ApidocComment("控制器id")
 	private Long controllerId;

	@Tfd("CONTROLLER_CLASS")
	@ApidocComment("控制器名称")
	private String controllerClass;

	@Tfd("METHOD_NAME")
 	@ApidocComment("接口方法名")
 	private String methodName;

	@Tfd("UNIQUE")
	@ApidocComment("接口唯一标识")
	private String unique;

	@Tfd("UPGRADE_STATUS")
	@ApidocComment("接口版本  0-最新版本 1-待更新")
	private Integer upgradeStatus;

	@Tfd("SHOW_NAME")
 	@ApidocComment("接口标题")
 	private String showName;

	@Tfd("PINYIN")
	@ApidocComment("接口标题拼音")
	private String pinyin;

	@Tfd("DESCRIPTION")
 	@ApidocComment("接口说明")
 	private String description;

	@Tfd("REQUEST_URL")
 	@ApidocComment("请求地址")
 	private String requestUrl;

	@Tfd("REQUEST_METHOD")
 	@ApidocComment("请求方式 0-全部  1-get  2-post ")
 	private Integer requestMethod;

	@Tfd("REQUEST_TYPE")
 	@ApidocComment("请求体类型 0-form  1-json体  2-文件上传 3-XML 4-RAW")
 	private Integer bodyType;

	@Tfd("SORT")
 	@ApidocComment("排序值")
 	private Integer sort = 0;

	@Tfd(value = "SOURCE",type = Blob.class)
	@ApidocComment("源代码")
	private String source;

	@Tfd("SEARCH_TAGS")
	@ApidocComment("搜索字段")
	private String searchTags;

	public static String buildSearchTag(DBModuleInterfaceEntity entity){
		if(entity == null){
			return "";
		}
		StringBuilder sb = new StringBuilder();
		if(!StringUtil.isEmpty(entity.getMethodName())){
			sb.append(entity.getMethodName());
		}
		if(!StringUtil.isEmpty(entity.getShowName())){
			sb.append(entity.getShowName());
		}
		if(!StringUtil.isEmpty(entity.getRequestUrl())){
			sb.append(entity.getRequestUrl());
		}
		if(!StringUtil.isEmpty(entity.getPinyin())){
			sb.append(entity.getPinyin());
		}
		if(!StringUtil.isEmpty(entity.getDescription())){
			sb.append(entity.getDescription());
		}
		if(sb.length() > 150){
			return sb.substring(0, 150);
		}
		return sb.toString();
	}


	public String getRequestMethodString(){
		if(this.requestMethod == null){
			return "GET";
		}
		switch (requestMethod){
			case 1:	return "GET";
			case 2:	return "POST";
			case 3:	return "PUT";
			case 4:	return "DELETE";
			case 5:	return "HEAD";
			case 6:	return "PATCH";
			case 7:	return "TRACE";
			case 8:	return "OPTIONS";
		}
		return "GET";
	}
	public void setRequestMethod(RequestMethod requestMethod){
		switch (requestMethod){
			case GET:
				this.requestMethod =  1;
				break;
			case DELETE:
				this.requestMethod =  4;
				break;
			case PUT:
				this.requestMethod =  3;
				break;
			case POST:
				this.requestMethod =  2;
				break;
			case HEAD:
				this.requestMethod =  5;
				break;
			case PATCH:
				this.requestMethod =  6;
				break;
			case TRACE:
				this.requestMethod =  7;
				break;
			case OPTIONS:
				this.requestMethod =  8;
				break;
		}
	}

	public Long getModuleId() {
		return moduleId;
	}

	public void setModuleId(Long moduleId) {
		this.moduleId = moduleId;
	}

	public Long getControllerId() {
		return controllerId;
	}

	public void setControllerId(Long controllerId) {
		this.controllerId = controllerId;
	}

	public String getMethodName() {
		return methodName;
	}

	public void setMethodName(String methodName) {
		this.methodName = methodName;
	}

	public String getShowName() {
		return showName;
	}

	public void setShowName(String showName) {
		this.showName = showName;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getRequestUrl() {
		return requestUrl;
	}

	public void setRequestUrl(String requestUrl) {
		this.requestUrl = requestUrl;
	}

	public Integer getRequestMethod() {
		return requestMethod;
	}

	public void setRequestMethod(Integer requestMethod) {
		this.requestMethod = requestMethod;
	}

	public Integer getBodyType() {
		return bodyType;
	}

	public void setBodyType(Integer bodyType) {
		this.bodyType = bodyType;
	}

	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}

	public String getPinyin() {
		return pinyin;
	}

	public void setPinyin(String pinyin) {
		this.pinyin = pinyin;
	}

	public String getSearchTags() {
		return searchTags;
	}

	public void setSearchTags(String searchTags) {
		this.searchTags = searchTags;
	}

	public String getControllerClass() {
		return controllerClass;
	}

	public void setControllerClass(String controllerClass) {
		this.controllerClass = controllerClass;
	}

	public String getUnique() {
		return unique;
	}

	public void setUnique(String unique) {
		this.unique = unique;
	}

	public Integer getUpgradeStatus() {
		return upgradeStatus;
	}

	public void setUpgradeStatus(Integer upgradeStatus) {
		this.upgradeStatus = upgradeStatus;
	}
}