package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;


/**
 * 模块访问环境配置
 */
@Tne("EASYAPI_MODULE_HOST")
public class DBModuleHostEntity extends BaseDbEntity {

	@Tfd("MODULE_ID")
	@ApidocComment("模块id")
	private Long moduleId;

	@Tfd("NAME")
	@ApidocComment("环境名称")
	private String name;

	@Tfd("DESCRIPTION")
	@ApidocComment("环境描述")
	private String description;

	@Tfd("HOST")
	@ApidocComment("环境ip或域名")
	private String host;

	@Tfd("DISABLE")
	@ApidocComment("环境状态:0-正常  1-关闭")
	private Integer disable;

	@Tfd("CAN_DELETE")
	@ApidocComment("是否可删除  0-不可删除  1-可以删除")
	private Integer canDelete;

	@Tfd("DEFAULT_STATUS")
	@ApidocComment("是否默认环境 0-不是  1-是")
	private Integer defaultStatus;

	public Long getModuleId() {
		return moduleId;
	}

	public void setModuleId(Long moduleId) {
		this.moduleId = moduleId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getHost() {
		return host;
	}

	public void setHost(String host) {
		this.host = host;
	}

	public Integer getDisable() {
		return disable;
	}

	public void setDisable(Integer disable) {
		this.disable = disable;
	}

	public Integer getDefaultStatus() {
		return defaultStatus;
	}

	public void setDefaultStatus(Integer defaultStatus) {
		this.defaultStatus = defaultStatus;
	}

	public Integer getCanDelete() {
		return canDelete;
	}

	public void setCanDelete(Integer canDelete) {
		this.canDelete = canDelete;
	}
}
