package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;

import java.sql.Blob;

/**
 * 接口参数
 */
@Tne("EASYAPI_INTERFACE_PARAM")
public class DBInterfaceParamEntity extends BaseDbEntity {

    @Tfd("INTERFACE_ID")
    @ApidocComment("接口id")
    private Long interfaceId;

    @Tfd("REQUEST_DESCRIPTION")
    @ApidocComment("请求参数说明")
    private String requestParamRemark;

    @Tfd("RESPONSE_DESCRIPTION")
    @ApidocComment("响应参数说明")
    private String responseParamRemark;

    @Tfd(value = "REQUEST_PARAM_JSON",type = Blob.class)
    @ApidocComment("请求参数详情json")
    private String requestParamJson;

    @Tfd(value = "RESPONSE_PARAM_JSON",type = Blob.class)
    @ApidocComment("响应参数详情json")
    private String responseParamJson;

    @Tfd(value = "RESPONSE_MOCK",type = Blob.class)
    @ApidocComment("接口mock")
    private String responseMock;

    @Tfd(value = "REQUEST_MOCK",type = Blob.class)
    @ApidocComment("接口mock")
    private String requestMock;

    public Long getInterfaceId() {
        return interfaceId;
    }

    public void setInterfaceId(Long interfaceId) {
        this.interfaceId = interfaceId;
    }

    public String getRequestParamRemark() {
        return requestParamRemark;
    }

    public void setRequestParamRemark(String requestParamRemark) {
        this.requestParamRemark = requestParamRemark;
    }

    public String getResponseParamRemark() {
        return responseParamRemark;
    }

    public void setResponseParamRemark(String responseParamRemark) {
        this.responseParamRemark = responseParamRemark;
    }

    public String getRequestParamJson() {
        return requestParamJson;
    }

    public void setRequestParamJson(String requestParamJson) {
        this.requestParamJson = requestParamJson;
    }

    public String getResponseParamJson() {
        return responseParamJson;
    }

    public void setResponseParamJson(String responseParamJson) {
        this.responseParamJson = responseParamJson;
    }

    public String getResponseMock() {
        return responseMock;
    }

    public void setResponseMock(String responseMock) {
        this.responseMock = responseMock;
    }

    public String getRequestMock() {
        return requestMock;
    }

    public void setRequestMock(String requestMock) {
        this.requestMock = requestMock;
    }
}
