package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;

import java.sql.Blob;

/**
 * 文章表
 */
@Tne("EASYAPI_ARTICLE")
public class DBArticleEntity extends BaseDbEntity{

    @Tfd("TITLE")
    @ApidocComment("文章标题")
    private String title;

    @Tfd(value = "CONTENT",type = Blob.class)
    @ApidocComment("文章内容")
    private String content;

    @Tfd(value = "H5",type = Blob.class)
    @ApidocComment("底部自定义h5")
    private String h5;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getH5() {
        return h5;
    }

    public void setH5(String h5) {
        this.h5 = h5;
    }
}
