package cn.easyutil.easyapi.entity.db.auth;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;

/**
 * 角色对应的权限
 */
@Tne("EASYAPI_USER_TEMPORARY_AUTH")
public class DBUserTemporaryAuthEntity extends BaseDbEntity {

    @Tfd("MODULE_ID")
    @ApidocComment("模块id")
    private Long moduleId;

    @Tfd("USER_ID")
    @ApidocComment("用户id")
    private Long userId;

    @Tfd("AUTH_CODE")
    @ApidocComment("可访问的接口编码")
    private Integer authCode;

    public Long getModuleId() {
        return moduleId;
    }

    public void setModuleId(Long moduleId) {
        this.moduleId = moduleId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getAuthCode() {
        return authCode;
    }

    public void setAuthCode(Integer authCode) {
        this.authCode = authCode;
    }
}
