package cn.easyutil.easyapi.entity.db.auth;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;

import java.util.List;

/**
 * 用户
 */
@Tne("EASYAPI_USER")
public class DBUserEntity extends BaseDbEntity {

    @Tfd("ACCOUNT")
    @ApidocComment("账号名")
    private String account;

    @Tfd("PASSWORD")
    @ApidocComment("密码")
    private String password;

    @Tfd("MOBILE")
    @ApidocComment("手机号码")
    private String mobile;

    @Tfd("DESCRIPTION")
    @ApidocComment("介绍")
    private String description;

    @Tfd("HEADER_IMG")
    @ApidocComment("头像")
    private String headerImg;

    @Tfd("NICK_NAME")
    @ApidocComment("昵称")
    private String nickName;

    @Tfd("LAST_LOGIN_TIME")
    @ApidocComment("上次登陆时间")
    private Long lastLoginTime;

    @Tfd("DISABLE")
    @ApidocComment("0-未禁用 1-已禁用")
    private Integer disable;

    @Tfd("SUPER_ADMIN_STATUS")
    @ApidocComment("是否超级管理员:0-不是  1-是")
    private Integer superAdminStatus;

    @Tfd("ROLE_ID")
    @ApidocComment("角色id")
    private Long roleId;

    @Tfd("HIDDEN")
    @ApidocComment("是否隐藏:0-不隐藏  1-隐藏")
    private Integer hidden;

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getHeaderImg() {
        return headerImg;
    }

    public void setHeaderImg(String headerImg) {
        this.headerImg = headerImg;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public Long getLastLoginTime() {
        return lastLoginTime;
    }

    public void setLastLoginTime(Long lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public Integer getDisable() {
        return disable;
    }

    public void setDisable(Integer disable) {
        this.disable = disable;
    }

    public Integer getSuperAdminStatus() {
        return superAdminStatus;
    }

    public void setSuperAdminStatus(Integer superAdminStatus) {
        this.superAdminStatus = superAdminStatus;
    }

    public Long getRoleId() {
        return roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public Integer getHidden() {
        return hidden;
    }

    public void setHidden(Integer hidden) {
        this.hidden = hidden;
    }
}
